/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockInputStream;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInputStream
extends InputStream
implements Seekable,
CanUnbuffer {
    private static final Logger LOG = LoggerFactory.getLogger(KeyInputStream.class);
    private static final int EOF = -1;
    private String key;
    private long length = 0L;
    private boolean closed = false;
    private final List<BlockInputStream> blockStreams = new ArrayList<BlockInputStream>();
    private long[] blockOffsets = null;
    private int blockIndex = 0;
    private int blockIndexOfPrevPosition;

    public static LengthInputStream getFromOmKeyInfo(OmKeyInfo keyInfo, XceiverClientFactory xceiverClientFactory, boolean verifyChecksum, Function<OmKeyInfo, OmKeyInfo> retryFunction) {
        List keyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        KeyInputStream keyInputStream = new KeyInputStream();
        keyInputStream.initialize(keyInfo, keyLocationInfos, xceiverClientFactory, verifyChecksum, retryFunction);
        return new LengthInputStream((InputStream)keyInputStream, keyInputStream.length);
    }

    public static List<LengthInputStream> getStreamsFromKeyInfo(OmKeyInfo keyInfo, XceiverClientFactory xceiverClientFactory, boolean verifyChecksum, Function<OmKeyInfo, OmKeyInfo> retryFunction) {
        List keyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        ArrayList<LengthInputStream> lengthInputStreams = new ArrayList<LengthInputStream>();
        HashMap partsToBlocksMap = new HashMap();
        HashMap<Integer, Long> partsLengthMap = new HashMap<Integer, Long>();
        for (OmKeyLocationInfo omKeyLocationInfo : keyLocationInfos) {
            int partNumber = omKeyLocationInfo.getPartNumber();
            if (!partsToBlocksMap.containsKey(partNumber)) {
                partsToBlocksMap.put(partNumber, new ArrayList());
                partsLengthMap.put(partNumber, 0L);
            }
            ((List)partsToBlocksMap.get(partNumber)).add(omKeyLocationInfo);
            partsLengthMap.put(partNumber, (Long)partsLengthMap.get(partNumber) + omKeyLocationInfo.getLength());
        }
        for (Map.Entry entry : partsToBlocksMap.entrySet()) {
            KeyInputStream keyInputStream = new KeyInputStream();
            keyInputStream.initialize(keyInfo, (List)entry.getValue(), xceiverClientFactory, verifyChecksum, retryFunction);
            lengthInputStreams.add(new LengthInputStream((InputStream)keyInputStream, ((Long)partsLengthMap.get(entry.getKey())).longValue()));
        }
        return lengthInputStreams;
    }

    private synchronized void initialize(OmKeyInfo keyInfo, List<OmKeyLocationInfo> blockInfos, XceiverClientFactory xceiverClientFactory, boolean verifyChecksum, Function<OmKeyInfo, OmKeyInfo> retryFunction) {
        this.key = keyInfo.getKeyName();
        this.blockOffsets = new long[blockInfos.size()];
        long keyLength = 0L;
        for (int i = 0; i < blockInfos.size(); ++i) {
            OmKeyLocationInfo omKeyLocationInfo = blockInfos.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding stream for accessing {}. The stream will be initialized later.", (Object)omKeyLocationInfo);
            }
            this.addStream(omKeyLocationInfo, xceiverClientFactory, verifyChecksum, keyLocationInfo -> {
                OmKeyInfo newKeyInfo = (OmKeyInfo)retryFunction.apply(keyInfo);
                BlockID blockID = keyLocationInfo.getBlockID();
                List collect = newKeyInfo.getLatestVersionLocations().getLocationList().stream().filter(l -> l.getBlockID().equals((Object)blockID)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    return ((OmKeyLocationInfo)collect.get(0)).getPipeline();
                }
                return null;
            });
            this.blockOffsets[i] = keyLength;
            keyLength += omKeyLocationInfo.getLength();
        }
        this.length = keyLength;
    }

    private synchronized void addStream(OmKeyLocationInfo blockInfo, XceiverClientFactory xceiverClientFactory, boolean verifyChecksum, Function<OmKeyLocationInfo, Pipeline> refreshPipelineFunction) {
        this.blockStreams.add(new BlockInputStream(blockInfo.getBlockID(), blockInfo.getLength(), blockInfo.getPipeline(), blockInfo.getToken(), verifyChecksum, xceiverClientFactory, blockID -> (Pipeline)refreshPipelineFunction.apply(blockInfo)));
    }

    @VisibleForTesting
    public void addStream(BlockInputStream blockInputStream) {
        this.blockStreams.add(blockInputStream);
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return Byte.toUnsignedInt(buf[0]);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int totalReadLen = 0;
        while (len > 0) {
            int numBytesToRead;
            if (this.blockStreams.size() == 0 || this.blockStreams.size() - 1 <= this.blockIndex && this.blockStreams.get(this.blockIndex).getRemaining() == 0L) {
                return totalReadLen == 0 ? -1 : totalReadLen;
            }
            BlockInputStream current = this.blockStreams.get(this.blockIndex);
            int numBytesRead = current.read(b, off, numBytesToRead = Math.min(len, (int)current.getRemaining()));
            if (numBytesRead != numBytesToRead) {
                throw new IOException(String.format("Inconsistent read for blockID=%s length=%d numBytesToRead=%d numBytesRead=%d", current.getBlockID(), current.getLength(), numBytesToRead, numBytesRead));
            }
            totalReadLen += numBytesRead;
            off += numBytesRead;
            len -= numBytesRead;
            if (current.getRemaining() > 0L || this.blockIndex + 1 >= this.blockStreams.size()) continue;
            ++this.blockIndex;
        }
        return totalReadLen;
    }

    public synchronized void seek(long pos) throws IOException {
        this.checkOpen();
        if (pos == 0L && this.length == 0L) {
            return;
        }
        if (pos < 0L || pos > this.length) {
            throw new EOFException("EOF encountered at pos: " + pos + " for key: " + this.key);
        }
        if (this.blockIndex >= this.blockStreams.size()) {
            this.blockIndex = Arrays.binarySearch(this.blockOffsets, pos);
        } else if (pos < this.blockOffsets[this.blockIndex]) {
            this.blockIndex = Arrays.binarySearch(this.blockOffsets, 0, this.blockIndex, pos);
        } else if (pos >= this.blockOffsets[this.blockIndex] + this.blockStreams.get(this.blockIndex).getLength()) {
            this.blockIndex = Arrays.binarySearch(this.blockOffsets, this.blockIndex + 1, this.blockStreams.size(), pos);
        }
        if (this.blockIndex < 0) {
            this.blockIndex = -this.blockIndex - 2;
        }
        this.blockStreams.get(this.blockIndexOfPrevPosition).resetPosition();
        for (int index = this.blockIndex + 1; index < this.blockStreams.size(); ++index) {
            this.blockStreams.get(index).seek(0L);
        }
        this.blockStreams.get(this.blockIndex).seek(pos - this.blockOffsets[this.blockIndex]);
        this.blockIndexOfPrevPosition = this.blockIndex;
    }

    public synchronized long getPos() throws IOException {
        return this.length == 0L ? 0L : this.blockOffsets[this.blockIndex] + this.blockStreams.get(this.blockIndex).getPos();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public int available() throws IOException {
        this.checkOpen();
        long remaining = this.length - this.getPos();
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (BlockInputStream blockStream : this.blockStreams) {
            blockStream.close();
        }
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Key: " + this.key);
        }
    }

    @VisibleForTesting
    public synchronized int getCurrentStreamIndex() {
        return this.blockIndex;
    }

    @VisibleForTesting
    public long getRemainingOfIndex(int index) throws IOException {
        return this.blockStreams.get(index).getRemaining();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(n, this.length - this.getPos());
        this.seek(this.getPos() + toSkip);
        return toSkip;
    }

    public void unbuffer() {
        for (BlockInputStream is : this.blockStreams) {
            is.unbuffer();
        }
    }

    @VisibleForTesting
    public List<BlockInputStream> getBlockStreams() {
        return this.blockStreams;
    }
}

