/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hadoop.hdds.db")
public class RocksDBConfiguration {
    @Config(key="rocksdb.logging.enabled", type=ConfigType.BOOLEAN, defaultValue="false", tags={ConfigTag.OM}, description="Enable/Disable RocksDB logging for OM.")
    private boolean rocksdbLogEnabled;
    @Config(key="rocksdb.logging.level", type=ConfigType.STRING, defaultValue="INFO", tags={ConfigTag.OM}, description="OM RocksDB logging level (INFO/DEBUG/WARN/ERROR/FATAL)")
    private String rocksdbLogLevel;
    @Config(key="rocksdb.writeoption.sync", type=ConfigType.BOOLEAN, defaultValue="false", tags={ConfigTag.OM}, description="Enable/Disable Sync option. If true write will be considered complete, once flushed to persistent storage. If false, writes are flushed asynchronously.")
    private boolean syncOption;

    public void setRocksdbLoggingEnabled(boolean enabled) {
        this.rocksdbLogEnabled = enabled;
    }

    public boolean isRocksdbLoggingEnabled() {
        return this.rocksdbLogEnabled;
    }

    public void setRocksdbLogLevel(String level) {
        this.rocksdbLogLevel = level;
    }

    public String getRocksdbLogLevel() {
        return this.rocksdbLogLevel;
    }

    public void setSyncOption(boolean enabled) {
        this.syncOption = enabled;
    }

    public boolean getSyncOption() {
        return this.syncOption;
    }
}

