/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBConfigFromFile;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.TableConfig;
import org.eclipse.jetty.util.StringUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.RocksDB;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DBStoreBuilder.class);
    public static final Logger ROCKS_DB_LOGGER = LoggerFactory.getLogger(RocksDB.class);
    private static final String DEFAULT_COLUMN_FAMILY_NAME = StringUtils.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY);
    public static final DBProfile HDDS_DEFAULT_DB_PROFILE = DBProfile.DISK;
    private final DBOptions defaultDBOptions;
    private DBOptions rocksDBOption;
    private ColumnFamilyOptions defaultCfOptions;
    private String dbname;
    private Path dbPath;
    private Map<String, ColumnFamilyOptions> cfOptions = new HashMap<String, ColumnFamilyOptions>();
    private ConfigurationSource configuration;
    private CodecRegistry registry;
    private String rocksDbStat;
    private RocksDBConfiguration rocksDBConfiguration;
    private boolean openReadOnly = false;

    public static DBStore createDBStore(ConfigurationSource configuration, DBDefinition definition) throws IOException {
        return DBStoreBuilder.newBuilder(configuration, definition).build();
    }

    public static DBStoreBuilder newBuilder(ConfigurationSource configuration, DBDefinition definition) {
        DBStoreBuilder builder = DBStoreBuilder.newBuilder(configuration);
        builder.applyDBDefinition(definition);
        return builder;
    }

    public static DBStoreBuilder newBuilder(ConfigurationSource configuration) {
        return DBStoreBuilder.newBuilder(configuration, (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class));
    }

    public static DBStoreBuilder newBuilder(ConfigurationSource configuration, RocksDBConfiguration rocksDBConfiguration) {
        return new DBStoreBuilder(configuration, rocksDBConfiguration);
    }

    private DBStoreBuilder(ConfigurationSource configuration, RocksDBConfiguration rocksDBConfiguration) {
        this.configuration = configuration;
        this.registry = new CodecRegistry();
        this.rocksDbStat = configuration.getTrimmed("ozone.metastore.rocksdb.statistics", "OFF");
        this.rocksDBConfiguration = rocksDBConfiguration;
        DBProfile dbProfile = (DBProfile)this.configuration.getEnum("hdds.db.profile", (Enum)HDDS_DEFAULT_DB_PROFILE);
        LOG.debug("Default DB profile:{}", (Object)dbProfile);
        this.defaultDBOptions = dbProfile.getDBOptions();
        this.setDefaultCFOptions(dbProfile.getColumnFamilyOptions());
    }

    private void applyDBDefinition(DBDefinition definition) {
        File metadataDir = definition.getDBLocation(this.configuration);
        if (metadataDir == null) {
            LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)definition.getLocationConfigKey(), (Object)"ozone.metadata.dirs");
            metadataDir = ServerUtils.getOzoneMetaDirPath(this.configuration);
        }
        this.setName(definition.getName());
        this.setPath(Paths.get(metadataDir.getPath(), new String[0]));
        for (DBColumnFamilyDefinition columnFamily : definition.getColumnFamilies()) {
            this.addTable(columnFamily.getName());
            this.addCodec(columnFamily.getKeyType(), columnFamily.getKeyCodec());
            this.addCodec(columnFamily.getValueType(), columnFamily.getValueCodec());
        }
    }

    public DBStore build() throws IOException {
        if (StringUtil.isBlank((String)this.dbname) || this.dbPath == null) {
            LOG.error("Required Parameter missing.");
            throw new IOException("Required parameter is missing. Please make sure Path and DB name is provided.");
        }
        Set<TableConfig> tableConfigs = this.makeTableConfigs();
        if (this.rocksDBOption == null) {
            this.rocksDBOption = this.getDefaultDBOptions(tableConfigs);
        }
        WriteOptions writeOptions = new WriteOptions();
        writeOptions.setSync(this.rocksDBConfiguration.getSyncOption());
        File dbFile = this.getDBFile();
        if (!dbFile.getParentFile().exists()) {
            throw new IOException("The DB destination directory should exist.");
        }
        return new RDBStore(dbFile, this.rocksDBOption, writeOptions, tableConfigs, this.registry, this.openReadOnly);
    }

    public DBStoreBuilder setName(String name) {
        this.dbname = name;
        return this;
    }

    public DBStoreBuilder addTable(String tableName) {
        return this.addTable(tableName, null);
    }

    public DBStoreBuilder addTable(String tableName, ColumnFamilyOptions options) {
        this.cfOptions.put(tableName, options);
        return this;
    }

    public <T> DBStoreBuilder addCodec(Class<T> type, Codec<T> codec) {
        this.registry.addCodec(type, codec);
        return this;
    }

    public DBStoreBuilder setDBOptions(DBOptions option) {
        this.rocksDBOption = option;
        return this;
    }

    public DBStoreBuilder setDefaultCFOptions(ColumnFamilyOptions options) {
        this.defaultCfOptions = options;
        return this;
    }

    public DBStoreBuilder setPath(Path path) {
        Preconditions.checkNotNull((Object)path);
        this.dbPath = path;
        return this;
    }

    public DBStoreBuilder setOpenReadOnly(boolean readOnly) {
        this.openReadOnly = readOnly;
        return this;
    }

    public DBStoreBuilder setProfile(DBProfile prof) {
        this.setDBOptions(prof.getDBOptions());
        this.setDefaultCFOptions(prof.getColumnFamilyOptions());
        return this;
    }

    private Set<TableConfig> makeTableConfigs() {
        HashSet<TableConfig> tableConfigs = new HashSet<TableConfig>();
        this.cfOptions.putIfAbsent(DEFAULT_COLUMN_FAMILY_NAME, this.defaultCfOptions);
        for (Map.Entry<String, ColumnFamilyOptions> entry : this.cfOptions.entrySet()) {
            String name = entry.getKey();
            ColumnFamilyOptions options = entry.getValue();
            if (options == null) {
                LOG.debug("using default column family options for table: {}", (Object)name);
                tableConfigs.add(new TableConfig(name, this.defaultCfOptions));
                continue;
            }
            tableConfigs.add(new TableConfig(name, options));
        }
        return tableConfigs;
    }

    private DBOptions getDefaultDBOptions(Collection<TableConfig> tableConfigs) {
        DBOptions dbOptions = this.getDBOptionsFromFile(tableConfigs);
        if (dbOptions == null) {
            dbOptions = this.defaultDBOptions;
            LOG.debug("Using RocksDB DBOptions from default profile.");
        }
        if (this.rocksDBConfiguration.isRocksdbLoggingEnabled()) {
            org.rocksdb.Logger logger = new org.rocksdb.Logger(dbOptions){

                protected void log(InfoLogLevel infoLogLevel, String s) {
                    ROCKS_DB_LOGGER.info(s);
                }
            };
            InfoLogLevel level = InfoLogLevel.valueOf((String)(this.rocksDBConfiguration.getRocksdbLogLevel() + "_LEVEL"));
            logger.setInfoLogLevel(level);
            dbOptions.setLogger(logger);
        }
        if (!this.rocksDbStat.equals("OFF")) {
            Statistics statistics = new Statistics();
            statistics.setStatsLevel(StatsLevel.valueOf((String)this.rocksDbStat));
            dbOptions = dbOptions.setStatistics(statistics);
        }
        return dbOptions;
    }

    private DBOptions getDBOptionsFromFile(Collection<TableConfig> tableConfigs) {
        DBOptions option = null;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>();
        if (StringUtil.isNotBlank((String)this.dbname)) {
            for (TableConfig tc : tableConfigs) {
                columnFamilyDescriptors.add(tc.getDescriptor());
            }
            if (columnFamilyDescriptors.size() > 0) {
                try {
                    option = DBConfigFromFile.readFromFile(this.dbname, columnFamilyDescriptors);
                    if (option != null) {
                        LOG.info("Using RocksDB DBOptions from {}.ini file", (Object)this.dbname);
                    }
                }
                catch (IOException ex) {
                    LOG.info("Unable to read RocksDB DBOptions from {}", (Object)this.dbname, (Object)ex);
                }
            }
        }
        return option;
    }

    private File getDBFile() throws IOException {
        if (this.dbPath == null) {
            LOG.error("DB path is required.");
            throw new IOException("A Path to for DB file is needed.");
        }
        if (StringUtil.isBlank((String)this.dbname)) {
            LOG.error("DBName is a required.");
            throw new IOException("A valid DB name is required.");
        }
        return Paths.get(this.dbPath.toString(), this.dbname).toFile();
    }
}

