/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;

public class DBColumnFamilyDefinition<KEY, VALUE> {
    private final String tableName;
    private final Class<KEY> keyType;
    private final Codec<KEY> keyCodec;
    private final Class<VALUE> valueType;
    private final Codec<VALUE> valueCodec;

    public DBColumnFamilyDefinition(String tableName, Class<KEY> keyType, Codec<KEY> keyCodec, Class<VALUE> valueType, Codec<VALUE> valueCodec) {
        this.tableName = tableName;
        this.keyType = keyType;
        this.keyCodec = keyCodec;
        this.valueType = valueType;
        this.valueCodec = valueCodec;
    }

    public Table<KEY, VALUE> getTable(DBStore db) throws IOException {
        return db.getTable(this.tableName, this.keyType, this.valueType);
    }

    public String getName() {
        return this.tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<KEY> getKeyType() {
        return this.keyType;
    }

    public Codec<KEY> getKeyCodec() {
        return this.keyCodec;
    }

    public Class<VALUE> getValueType() {
        return this.valueType;
    }

    public Codec<VALUE> getValueCodec() {
        return this.valueCodec;
    }
}

