/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.PKIProfile;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfile
implements PKIProfile {
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_KEY_USAGE = DefaultProfile::validateKeyUsage;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_AUTHORITY_KEY_IDENTIFIER = (e, b) -> Boolean.TRUE;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_LOGO_TYPE = (e, b) -> Boolean.TRUE;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProfile.class);
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_SAN = DefaultProfile::validateSubjectAlternativeName;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_EXTENDED_KEY_USAGE = DefaultProfile::validateExtendedKeyUsage;
    private static final int[] GENERAL_NAMES = new int[]{2, 7, 0};
    private static final Map<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>> EXTENSIONS_MAP = Stream.of(new AbstractMap.SimpleEntry<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>>(Extension.keyUsage, VALIDATE_KEY_USAGE), new AbstractMap.SimpleEntry<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>>(Extension.subjectAlternativeName, VALIDATE_SAN), new AbstractMap.SimpleEntry<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>>(Extension.authorityKeyIdentifier, VALIDATE_AUTHORITY_KEY_IDENTIFIER), new AbstractMap.SimpleEntry<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>>(Extension.extendedKeyUsage, VALIDATE_EXTENDED_KEY_USAGE), new AbstractMap.SimpleEntry<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>>(Extension.logoType, VALIDATE_LOGO_TYPE)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final KeyPurposeId[] EXTENDED_KEY_USAGE = new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth};
    private final Set<KeyPurposeId> extendKeyPurposeSet;
    private Set<Integer> generalNameSet = new HashSet<Integer>();

    public DefaultProfile() {
        for (int val : GENERAL_NAMES) {
            this.generalNameSet.add(val);
        }
        this.extendKeyPurposeSet = new HashSet<KeyPurposeId>(Arrays.asList(EXTENDED_KEY_USAGE));
    }

    private static Boolean validateKeyUsage(Extension ext, PKIProfile profile) {
        KeyUsage keyUsage = profile.getKeyUsage();
        KeyUsage requestedUsage = KeyUsage.getInstance((Object)ext.getParsedValue());
        BitSet profileBitSet = BitSet.valueOf(keyUsage.getBytes());
        BitSet requestBitSet = BitSet.valueOf(requestedUsage.getBytes());
        profileBitSet.and(requestBitSet);
        return profileBitSet.equals(requestBitSet);
    }

    private static Boolean validateSubjectAlternativeName(Extension ext, PKIProfile profile) {
        if (ext.isCritical()) {
            LOG.error("SAN extension marked as critical in the Extension. {}", (Object)GeneralNames.getInstance((Object)ext.getParsedValue()).toString());
            return false;
        }
        GeneralNames generalNames = GeneralNames.getInstance((Object)ext.getParsedValue());
        for (GeneralName name : generalNames.getNames()) {
            try {
                if (profile.validateGeneralName(name.getTagNo(), name.getName().toString())) continue;
                return false;
            }
            catch (UnknownHostException e) {
                LOG.error("IP address validation failed." + name.getName().toString(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static Boolean validateExtendedKeyUsage(Extension ext, PKIProfile profile) {
        if (ext.isCritical()) {
            LOG.error("Extended Key usage marked as critical.");
            return false;
        }
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)ext.getParsedValue());
        for (KeyPurposeId id : extendedKeyUsage.getUsages()) {
            if (profile.validateExtendedKeyUsage(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] getGeneralNames() {
        return Arrays.copyOfRange(GENERAL_NAMES, 0, GENERAL_NAMES.length);
    }

    @Override
    public boolean isSupportedGeneralName(int generalName) {
        return this.generalNameSet.contains(generalName);
    }

    @Override
    public boolean validateGeneralName(int type, String value) {
        if (!this.isSupportedGeneralName(type)) {
            return false;
        }
        switch (type) {
            case 7: {
                try {
                    InetAddress byAddress = InetAddress.getByAddress(Hex.decodeHex((String)value.substring(1)));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Host Name/IP Address : {}", (Object)byAddress.toString());
                    }
                    return true;
                }
                catch (UnknownHostException | DecoderException e) {
                    return false;
                }
            }
            case 2: {
                return DomainValidator.getInstance().isValid(value);
            }
            case 0: {
                return true;
            }
        }
        LOG.error("Unexpected type in General Name (int value) : {}", (Object)type);
        return false;
    }

    @Override
    public boolean validateExtendedKeyUsage(KeyPurposeId id) {
        return this.extendKeyPurposeSet.contains(id);
    }

    @Override
    public ASN1ObjectIdentifier[] getSupportedExtensions() {
        return EXTENSIONS_MAP.keySet().toArray(new ASN1ObjectIdentifier[0]);
    }

    @Override
    public boolean isSupportedExtension(Extension extension) {
        return EXTENSIONS_MAP.containsKey(extension.getExtnId());
    }

    @Override
    public boolean validateExtension(Extension extension) {
        Preconditions.checkNotNull((Object)extension, (Object)"Extension cannot be null");
        if (!this.isSupportedExtension(extension)) {
            LOG.error("Unsupported Extension found: {} ", (Object)extension.getExtnId().getId());
            return false;
        }
        BiFunction<Extension, PKIProfile, Boolean> func = EXTENSIONS_MAP.get(extension.getExtnId());
        if (func != null) {
            return func.apply(extension, this);
        }
        return false;
    }

    @Override
    public KeyUsage getKeyUsage() {
        return new KeyUsage(184);
    }

    @Override
    public RDN[] getRDNs() {
        return new RDN[0];
    }

    @Override
    public boolean isValidRDN(RDN distinguishedName) {
        return true;
    }

    @Override
    public boolean validateRDN(RDN name) {
        return true;
    }

    @Override
    public boolean isCA() {
        return false;
    }
}

