/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CRLApprover;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CRLCodec;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class DefaultCRLApprover
implements CRLApprover {
    private SecurityConfig config;
    private PrivateKey caPrivate;

    public DefaultCRLApprover(SecurityConfig config, PrivateKey caPrivate) {
        this.config = config;
        this.caPrivate = caPrivate;
    }

    @Override
    public X509CRL sign(X509v2CRLBuilder builder) throws CRLException, OperatorCreationException {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(this.config.getSignatureAlgo());
        contentSignerBuilder.setProvider(this.config.getProvider());
        X509CRLHolder crlHolder = builder.build(contentSignerBuilder.build(this.caPrivate));
        return CRLCodec.getX509CRL(crlHolder);
    }
}

