/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CRLApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMCertStore
implements CertificateStore {
    private static final Logger LOG = LoggerFactory.getLogger(SCMCertStore.class);
    private final SCMMetadataStore scmMetadataStore;
    private final Lock lock;
    private AtomicLong crlSequenceId;

    public SCMCertStore(SCMMetadataStore dbStore, long sequenceId) {
        this.scmMetadataStore = dbStore;
        this.lock = new ReentrantLock();
        this.crlSequenceId = new AtomicLong(sequenceId);
    }

    public void storeValidCertificate(BigInteger serialID, X509Certificate certificate) throws IOException {
        block4: {
            this.lock.lock();
            try {
                if (this.getCertificateByID(serialID, CertificateStore.CertType.VALID_CERTS) == null && this.getCertificateByID(serialID, CertificateStore.CertType.REVOKED_CERTS) == null) {
                    this.scmMetadataStore.getValidCertsTable().put((Object)serialID, (Object)certificate);
                    break block4;
                }
                throw new SCMSecurityException("Conflicting certificate ID");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> revokeCertificates(List<BigInteger> serialIDs, X509CertificateHolder caCertificateHolder, CRLReason reason, Date revocationTime, CRLApprover crlApprover) throws IOException {
        Optional<Long> sequenceId;
        block22: {
            Date now = new Date();
            X509v2CRLBuilder builder = new X509v2CRLBuilder(caCertificateHolder.getIssuer(), now);
            ArrayList<Object> certsToRevoke = new ArrayList<Object>();
            sequenceId = Optional.empty();
            this.lock.lock();
            try {
                X509CRL crl;
                for (BigInteger serialID : serialIDs) {
                    X509Certificate cert = this.getCertificateByID(serialID, CertificateStore.CertType.VALID_CERTS);
                    if (cert == null && LOG.isWarnEnabled()) {
                        LOG.warn("Trying to revoke a certificate that is not valid. Serial ID: {}", (Object)serialID.toString());
                        continue;
                    }
                    if (this.getCertificateByID(serialID, CertificateStore.CertType.REVOKED_CERTS) != null) {
                        LOG.warn("Trying to revoke a certificate that is already revoked.");
                        continue;
                    }
                    builder.addCRLEntry(serialID, revocationTime, reason.getValue().intValue());
                    certsToRevoke.add(cert);
                }
                if (certsToRevoke.isEmpty()) break block22;
                try {
                    crl = crlApprover.sign(builder);
                }
                catch (CRLException | OperatorCreationException e) {
                    throw new SCMSecurityException("Unable to create Certificate Revocation List.", e);
                }
                try (BatchOperation batch = this.scmMetadataStore.getStore().initBatchOperation();){
                    if (now.after(revocationTime) || now.equals(revocationTime)) {
                        for (X509Certificate x509Certificate : certsToRevoke) {
                            this.scmMetadataStore.getRevokedCertsTable().putWithBatch(batch, (Object)x509Certificate.getSerialNumber(), (Object)x509Certificate);
                            this.scmMetadataStore.getValidCertsTable().deleteWithBatch(batch, (Object)x509Certificate.getSerialNumber());
                        }
                    }
                    long id = this.crlSequenceId.incrementAndGet();
                    CRLInfo crlInfo = new CRLInfo.Builder().setX509CRL(crl).setCreationTimestamp(now.getTime()).build();
                    this.scmMetadataStore.getCRLInfoTable().putWithBatch(batch, (Object)id, (Object)crlInfo);
                    this.scmMetadataStore.getCRLSequenceIdTable().putWithBatch(batch, (Object)"CRL_SEQUENCE_ID", (Object)id);
                    this.scmMetadataStore.getStore().commitBatchOperation(batch);
                    sequenceId = Optional.of(id);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return sequenceId;
    }

    public void removeExpiredCertificate(BigInteger serialID) throws IOException {
    }

    public X509Certificate getCertificateByID(BigInteger serialID, CertificateStore.CertType certType) throws IOException {
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            return (X509Certificate)this.scmMetadataStore.getValidCertsTable().get((Object)serialID);
        }
        return (X509Certificate)this.scmMetadataStore.getRevokedCertsTable().get((Object)serialID);
    }

    public List<X509Certificate> listCertificate(HddsProtos.NodeType role, BigInteger startSerialID, int count, CertificateStore.CertType certType) throws IOException {
        if (startSerialID.longValue() == 0L) {
            startSerialID = null;
        }
        List certs = certType == CertificateStore.CertType.VALID_CERTS ? this.scmMetadataStore.getValidCertsTable().getRangeKVs((Object)startSerialID, count, new MetadataKeyFilters.MetadataKeyFilter[0]) : this.scmMetadataStore.getRevokedCertsTable().getRangeKVs((Object)startSerialID, count, new MetadataKeyFilters.MetadataKeyFilter[0]);
        ArrayList<X509Certificate> results = new ArrayList<X509Certificate>(certs.size());
        for (Table.KeyValue kv : certs) {
            try {
                X509Certificate cert = (X509Certificate)kv.getValue();
                results.add(cert);
            }
            catch (IOException e) {
                LOG.error("Fail to list certificate from SCM metadata store", (Throwable)e);
                throw new SCMSecurityException("Fail to list certificate from SCM metadata store.");
            }
        }
        return results;
    }
}

