/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.ContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.DataNodeSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.OneReplicaPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeMetrics;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMSafeModeManager
implements SafeModeManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMSafeModeManager.class);
    private final boolean isSafeModeEnabled;
    private final long waitTime;
    private AtomicBoolean inSafeMode = new AtomicBoolean(true);
    private AtomicBoolean preCheckComplete = new AtomicBoolean(false);
    private Map<String, SafeModeExitRule> exitRules = new HashMap<String, SafeModeExitRule>(1);
    private Set<String> preCheckRules = new HashSet<String>(1);
    private ConfigurationSource config;
    private static final String CONT_EXIT_RULE = "ContainerSafeModeRule";
    private static final String DN_EXIT_RULE = "DataNodeSafeModeRule";
    private static final String HEALTHY_PIPELINE_EXIT_RULE = "HealthyPipelineSafeModeRule";
    private static final String ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE = "AtleastOneDatanodeReportedRule";
    private Set<String> validatedRules = new HashSet<String>();
    private Set<String> validatedPreCheckRules = new HashSet<String>(1);
    private final EventQueue eventPublisher;
    private final PipelineManager pipelineManager;
    private final SafeModeMetrics safeModeMetrics;

    public SCMSafeModeManager(ConfigurationSource conf, List<ContainerInfo> allContainers, PipelineManager pipelineManager, EventQueue eventQueue) {
        this.config = conf;
        this.pipelineManager = pipelineManager;
        this.eventPublisher = eventQueue;
        this.isSafeModeEnabled = conf.getBoolean("hdds.scm.safemode.enabled", true);
        this.waitTime = conf.getTimeDuration("hdds.scm.wait.time.after.safemode.exit", "5m", TimeUnit.MILLISECONDS);
        if (this.isSafeModeEnabled) {
            boolean createPipelineInSafemode;
            this.safeModeMetrics = SafeModeMetrics.create();
            ContainerSafeModeRule containerSafeModeRule = new ContainerSafeModeRule(CONT_EXIT_RULE, eventQueue, this.config, allContainers, this);
            DataNodeSafeModeRule dataNodeSafeModeRule = new DataNodeSafeModeRule(DN_EXIT_RULE, eventQueue, this.config, this);
            this.exitRules.put(CONT_EXIT_RULE, containerSafeModeRule);
            this.exitRules.put(DN_EXIT_RULE, dataNodeSafeModeRule);
            this.preCheckRules.add(DN_EXIT_RULE);
            if (conf.getBoolean("hdds.scm.safemode.pipeline-availability.check", true) && pipelineManager != null) {
                HealthyPipelineSafeModeRule healthyPipelineSafeModeRule = new HealthyPipelineSafeModeRule(HEALTHY_PIPELINE_EXIT_RULE, eventQueue, pipelineManager, this, this.config);
                OneReplicaPipelineSafeModeRule oneReplicaPipelineSafeModeRule = new OneReplicaPipelineSafeModeRule(ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE, eventQueue, pipelineManager, this, conf);
                this.exitRules.put(HEALTHY_PIPELINE_EXIT_RULE, healthyPipelineSafeModeRule);
                this.exitRules.put(ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE, oneReplicaPipelineSafeModeRule);
            }
            if (createPipelineInSafemode = conf.getBoolean("hdds.scm.safemode.pipeline.creation", true)) {
                pipelineManager.startPipelineCreator();
            }
        } else {
            this.safeModeMetrics = null;
            this.exitSafeMode((EventPublisher)eventQueue);
        }
    }

    public void stop() {
        if (this.isSafeModeEnabled) {
            this.safeModeMetrics.unRegister();
        }
    }

    public SafeModeMetrics getSafeModeMetrics() {
        return this.safeModeMetrics;
    }

    @VisibleForTesting
    public void emitSafeModeStatus() {
        SafeModeStatus safeModeStatus = new SafeModeStatus(this.getInSafeMode(), this.getPreCheckComplete());
        this.eventPublisher.fireEvent(SCMEvents.SAFE_MODE_STATUS, (Object)safeModeStatus);
        if (safeModeStatus.isInSafeMode()) {
            this.eventPublisher.fireEvent(SCMEvents.DELAYED_SAFE_MODE_STATUS, (Object)safeModeStatus);
        } else {
            Thread safeModeExitThread = new Thread(() -> {
                try {
                    Thread.sleep(this.waitTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.eventPublisher.fireEvent(SCMEvents.DELAYED_SAFE_MODE_STATUS, (Object)safeModeStatus);
            });
            safeModeExitThread.setDaemon(true);
            safeModeExitThread.start();
        }
    }

    public synchronized void validateSafeModeExitRules(String ruleName, EventPublisher eventQueue) {
        if (this.exitRules.get(ruleName) != null) {
            this.validatedRules.add(ruleName);
            if (this.preCheckRules.contains(ruleName)) {
                this.validatedPreCheckRules.add(ruleName);
            }
            LOG.info("{} rule is successfully validated", (Object)ruleName);
        } else {
            LOG.error("No Such Exit rule {}", (Object)ruleName);
        }
        if (!this.getPreCheckComplete() && this.validatedPreCheckRules.size() == this.preCheckRules.size()) {
            this.completePreCheck(eventQueue);
        }
        if (this.validatedRules.size() == this.exitRules.size()) {
            LOG.info("ScmSafeModeManager, all rules are successfully validated");
            this.exitSafeMode(eventQueue);
        }
    }

    @VisibleForTesting
    public void completePreCheck(EventPublisher eventQueue) {
        LOG.info("All SCM safe mode pre check rules have passed");
        this.setPreCheckComplete(true);
        this.emitSafeModeStatus();
    }

    @VisibleForTesting
    public void exitSafeMode(EventPublisher eventQueue) {
        LOG.info("SCM exiting safe mode.");
        this.setPreCheckComplete(true);
        this.setInSafeMode(false);
        this.emitSafeModeStatus();
    }

    @Override
    public boolean getInSafeMode() {
        if (!this.isSafeModeEnabled) {
            return false;
        }
        return this.inSafeMode.get();
    }

    public Map<String, Pair<Boolean, String>> getRuleStatus() {
        HashMap<String, Pair<Boolean, String>> map = new HashMap<String, Pair<Boolean, String>>();
        for (SafeModeExitRule exitRule : this.exitRules.values()) {
            map.put(exitRule.getRuleName(), (Pair<Boolean, String>)Pair.of((Object)exitRule.validate(), (Object)exitRule.getStatusText()));
        }
        return map;
    }

    public boolean getPreCheckComplete() {
        return this.preCheckComplete.get();
    }

    public void setInSafeMode(boolean inSafeMode) {
        this.inSafeMode.set(inSafeMode);
    }

    public void setPreCheckComplete(boolean newState) {
        this.preCheckComplete.set(newState);
    }

    public static Logger getLogger() {
        return LOG;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return ((ContainerSafeModeRule)this.exitRules.get(CONT_EXIT_RULE)).getCurrentContainerThreshold();
    }

    @VisibleForTesting
    public HealthyPipelineSafeModeRule getHealthyPipelineSafeModeRule() {
        return (HealthyPipelineSafeModeRule)this.exitRules.get(HEALTHY_PIPELINE_EXIT_RULE);
    }

    @VisibleForTesting
    public OneReplicaPipelineSafeModeRule getOneReplicaPipelineSafeModeRule() {
        return (OneReplicaPipelineSafeModeRule)this.exitRules.get(ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE);
    }

    public static class SafeModeStatus {
        private boolean safeModeStatus;
        private boolean preCheckPassed;

        public SafeModeStatus(boolean safeModeState, boolean preCheckPassed) {
            this.safeModeStatus = safeModeState;
            this.preCheckPassed = preCheckPassed;
        }

        public boolean isInSafeMode() {
            return this.safeModeStatus;
        }

        public boolean isPreCheckComplete() {
            return this.preCheckPassed;
        }
    }
}

