/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclStorageUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

public final class OmPrefixInfo
extends WithObjectID {
    private String name;
    private List<OzoneAcl> acls;

    public OmPrefixInfo(String name, List<OzoneAcl> acls, Map<String, String> metadata, long objectId, long updateId) {
        this.name = name;
        this.acls = acls;
        this.metadata = metadata;
        this.objectID = objectId;
        this.updateID = updateId;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl acl) {
        return OzoneAclUtil.addAcl(this.acls, (OzoneAcl)acl);
    }

    public boolean removeAcl(OzoneAcl acl) {
        return OzoneAclUtil.removeAcl(this.acls, (OzoneAcl)acl);
    }

    public boolean setAcls(List<OzoneAcl> newAcls) {
        return OzoneAclUtil.setAcl(this.acls, newAcls);
    }

    public String getName() {
        return this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public OzoneManagerStorageProtos.PersistedPrefixInfo getProtobuf() {
        OzoneManagerStorageProtos.PersistedPrefixInfo.Builder pib = OzoneManagerStorageProtos.PersistedPrefixInfo.newBuilder().setName(this.name).addAllMetadata(KeyValueUtil.toProtobuf((Map)this.metadata));
        if (this.acls != null) {
            pib.addAllAcls(OzoneAclStorageUtil.toProtobuf(this.acls));
        }
        return pib.build();
    }

    public static OmPrefixInfo getFromProtobuf(OzoneManagerStorageProtos.PersistedPrefixInfo prefixInfo) {
        Builder opib = OmPrefixInfo.newBuilder().setName(prefixInfo.getName());
        if (prefixInfo.getMetadataList() != null) {
            opib.addAllMetadata(KeyValueUtil.getFromProtobuf(prefixInfo.getMetadataList()));
        }
        if (prefixInfo.getAclsList() != null) {
            opib.setAcls(OzoneAclStorageUtil.fromProtobuf(prefixInfo.getAclsList()));
        }
        return opib.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OmPrefixInfo that = (OmPrefixInfo)((Object)o);
        return this.name.equals(that.name) && Objects.equals(this.acls, that.acls) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public OmPrefixInfo copyObject() {
        List<OzoneAcl> aclList = this.acls.stream().map(acl -> new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())).collect(Collectors.toList());
        HashMap<String, String> metadataList = new HashMap<String, String>();
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> metadataList.put((String)k, (String)v));
        }
        return new OmPrefixInfo(this.name, aclList, metadataList, this.objectID, this.updateID);
    }

    public static class Builder {
        private String name;
        private List<OzoneAcl> acls = new LinkedList<OzoneAcl>();
        private Map<String, String> metadata = new HashMap<String, String>();
        private long objectID;
        private long updateID;

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder setName(String n) {
            this.name = n;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            if (additionalMetadata != null) {
                this.metadata.putAll(additionalMetadata);
            }
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public OmPrefixInfo build() {
            Preconditions.checkNotNull((Object)this.name);
            return new OmPrefixInfo(this.name, this.acls, this.metadata, this.objectID, this.updateID);
        }
    }
}

