/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatedOmKeyInfoCodec
implements Codec<RepeatedOmKeyInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(RepeatedOmKeyInfoCodec.class);
    private final boolean ignorePipeline;

    public RepeatedOmKeyInfoCodec(boolean ignorePipeline) {
        this.ignorePipeline = ignorePipeline;
        LOG.info("RepeatedOmKeyInfoCodec ignorePipeline = {}", (Object)ignorePipeline);
    }

    public byte[] toPersistedFormat(RepeatedOmKeyInfo object) throws IOException {
        Preconditions.checkNotNull((Object)object, (Object)"Null object can't be converted to byte array.");
        return object.getProto(this.ignorePipeline, 1).toByteArray();
    }

    public RepeatedOmKeyInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't converted to real object.");
        try {
            return RepeatedOmKeyInfo.getFromProto((OzoneManagerProtocolProtos.RepeatedKeyInfo)OzoneManagerProtocolProtos.RepeatedKeyInfo.parseFrom((byte[])rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public RepeatedOmKeyInfo copyObject(RepeatedOmKeyInfo object) {
        return object;
    }
}

