/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.spi.ContainerDBServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerKeyMapperTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerKeyMapperTask.class);
    private ContainerDBServiceProvider containerDBServiceProvider;

    @Inject
    public ContainerKeyMapperTask(ContainerDBServiceProvider containerDBServiceProvider) {
        this.containerDBServiceProvider = containerDBServiceProvider;
    }

    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        long omKeyCount = 0L;
        try {
            LOG.info("Starting a 'reprocess' run of ContainerKeyMapperTask.");
            Instant start = Instant.now();
            this.containerDBServiceProvider.initNewContainerDB(new HashMap<ContainerKeyPrefix, Integer>());
            Table omKeyInfoTable = omMetadataManager.getKeyTable();
            try (TableIterator keyIter = omKeyInfoTable.iterator();){
                while (keyIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                    OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                    this.writeOMKeyToContainerDB((String)kv.getKey(), omKeyInfo);
                    ++omKeyCount;
                }
            }
            LOG.info("Completed 'reprocess' of ContainerKeyMapperTask.");
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("It took me {} seconds to process {} keys.", (Object)((double)duration / 1000.0), (Object)omKeyCount);
        }
        catch (IOException ioEx) {
            LOG.error("Unable to populate Container Key Prefix data in Recon DB. ", (Throwable)ioEx);
            return new ImmutablePair((Object)this.getTaskName(), (Object)false);
        }
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    @Override
    public String getTaskName() {
        return "ContainerKeyMapperTask";
    }

    public Collection<String> getTaskTables() {
        return Collections.singletonList("keyTable");
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        int eventCount = 0;
        Collection<String> taskTables = this.getTaskTables();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            if (!taskTables.contains(omdbUpdateEvent.getTable())) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            OmKeyInfo updatedKeyValue = (OmKeyInfo)omdbUpdateEvent.getValue();
            try {
                switch (omdbUpdateEvent.getAction()) {
                    case PUT: {
                        this.writeOMKeyToContainerDB(updatedKey, updatedKeyValue);
                        break;
                    }
                    case DELETE: {
                        this.deleteOMKeyFromContainerDB(updatedKey);
                        break;
                    }
                    case UPDATE: {
                        if (omdbUpdateEvent.getOldValue() != null) {
                            this.deleteOMKeyFromContainerDB(((OmKeyInfo)omdbUpdateEvent.getOldValue()).getKeyName());
                        } else {
                            LOG.warn("Update event does not have the old Key Info for {}.", (Object)updatedKey);
                        }
                        this.writeOMKeyToContainerDB(updatedKey, updatedKeyValue);
                        break;
                    }
                    default: {
                        LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                    }
                }
                ++eventCount;
            }
            catch (IOException e) {
                LOG.error("Unexpected exception while updating key data : {} ", (Object)updatedKey, (Object)e);
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        LOG.info("{} successfully processed {} OM DB update event(s).", (Object)this.getTaskName(), (Object)eventCount);
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private void deleteOMKeyFromContainerDB(String key) throws IOException {
        TableIterator containerIterator = this.containerDBServiceProvider.getContainerTableIterator();
        HashSet<Object> keysToBeDeleted = new HashSet<Object>();
        while (containerIterator.hasNext()) {
            Table.KeyValue keyValue = (Table.KeyValue)containerIterator.next();
            String string = ((ContainerKeyPrefix)keyValue.getKey()).getKeyPrefix();
            if (!string.equals(key)) continue;
            keysToBeDeleted.add(keyValue.getKey());
        }
        for (ContainerKeyPrefix containerKeyPrefix : keysToBeDeleted) {
            this.containerDBServiceProvider.deleteContainerMapping(containerKeyPrefix);
            Long containerID = containerKeyPrefix.getContainerId();
            long keyCount = this.containerDBServiceProvider.getKeyCountForContainer(containerID);
            if (keyCount <= 0L) continue;
            this.containerDBServiceProvider.storeContainerKeyCount(containerID, --keyCount);
        }
    }

    private void writeOMKeyToContainerDB(String key, OmKeyInfo omKeyInfo) throws IOException {
        long containerCountToIncrement = 0L;
        for (OmKeyLocationInfoGroup omKeyLocationInfoGroup : omKeyInfo.getKeyLocationVersions()) {
            long keyVersion = omKeyLocationInfoGroup.getVersion();
            for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getLocationList()) {
                long containerId = omKeyLocationInfo.getContainerID();
                ContainerKeyPrefix containerKeyPrefix = new ContainerKeyPrefix(containerId, key, keyVersion);
                if (this.containerDBServiceProvider.getCountForContainerKeyPrefix(containerKeyPrefix) != 0) continue;
                this.containerDBServiceProvider.storeContainerKeyMapping(containerKeyPrefix, 1);
                if (!this.containerDBServiceProvider.doesContainerExists(containerId)) {
                    ++containerCountToIncrement;
                }
                long keyCount = this.containerDBServiceProvider.getKeyCountForContainer(containerId);
                this.containerDBServiceProvider.storeContainerKeyCount(containerId, ++keyCount);
            }
        }
        if (containerCountToIncrement > 0L) {
            this.containerDBServiceProvider.incrementContainerCountBy(containerCountToIncrement);
        }
    }
}

