/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.File;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconContainerDBProvider
implements Provider<DBStore> {
    @VisibleForTesting
    private static final Logger LOG = LoggerFactory.getLogger(ReconContainerDBProvider.class);
    private OzoneConfiguration configuration;
    private ReconUtils reconUtils;

    @Inject
    public ReconContainerDBProvider(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.configuration = configuration;
        this.reconUtils = reconUtils;
    }

    public DBStore get() {
        DBStore dbStore;
        File reconDbDir = this.reconUtils.getReconDbDir((ConfigurationSource)this.configuration, "ozone.recon.db.dir");
        File lastKnownContainerKeyDb = this.reconUtils.getLastKnownDB(reconDbDir, "recon-container-key.db");
        if (lastKnownContainerKeyDb != null) {
            LOG.info("Last known container-key DB : {}", (Object)lastKnownContainerKeyDb.getAbsolutePath());
            dbStore = ReconContainerDBProvider.initializeDBStore(this.configuration, lastKnownContainerKeyDb.getName());
        } else {
            dbStore = ReconContainerDBProvider.getNewDBStore(this.configuration);
        }
        if (dbStore == null) {
            throw new ProvisionException("Unable to provide instance of DBStore store.");
        }
        return dbStore;
    }

    private static DBStore initializeDBStore(OzoneConfiguration configuration, String dbName) {
        DBStore dbStore = null;
        try {
            dbStore = DBStoreBuilder.createDBStore((ConfigurationSource)configuration, (DBDefinition)new ReconDBDefinition(dbName));
        }
        catch (Exception ex) {
            LOG.error("Unable to initialize Recon container metadata store.", (Throwable)ex);
        }
        return dbStore;
    }

    static DBStore getNewDBStore(OzoneConfiguration configuration) {
        String dbName = "recon-container-key.db_" + System.currentTimeMillis();
        return ReconContainerDBProvider.initializeDBStore(configuration, dbName);
    }
}

