/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.metrics.OzoneManagerSyncMetrics;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.OzoneManagerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdatesHandler;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskController;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Time;
import org.apache.ratis.proto.RaftProtos;
import org.hadoop.ozone.recon.schema.tables.daos.ReconTaskStatusDao;
import org.hadoop.ozone.recon.schema.tables.pojos.ReconTaskStatus;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OzoneManagerServiceProviderImpl
implements OzoneManagerServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerServiceProviderImpl.class);
    private URLConnectionFactory connectionFactory;
    private File omSnapshotDBParentDir = null;
    private String omDBSnapshotUrl;
    private OzoneManagerProtocol ozoneManagerClient;
    private final OzoneConfiguration configuration;
    private ScheduledExecutorService scheduler;
    private ReconOMMetadataManager omMetadataManager;
    private ReconTaskController reconTaskController;
    private ReconTaskStatusDao reconTaskStatusDao;
    private ReconUtils reconUtils;
    private OzoneManagerSyncMetrics metrics;

    @Inject
    public OzoneManagerServiceProviderImpl(OzoneConfiguration configuration, ReconOMMetadataManager omMetadataManager, ReconTaskController reconTaskController, ReconUtils reconUtils, OzoneManagerProtocol ozoneManagerClient) {
        boolean flushParam;
        int connectionTimeout = (int)configuration.getTimeDuration("ozone.recon.om.connection.timeout", configuration.get("recon.om.connection.timeout", "5s"), TimeUnit.MILLISECONDS);
        int connectionRequestTimeout = (int)configuration.getTimeDuration("ozone.recon.om.connection.request.timeout", configuration.get("recon.om.connection.request.timeout", "5s"), TimeUnit.MILLISECONDS);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((int)connectionTimeout, (int)connectionRequestTimeout, (Configuration)configuration);
        String ozoneManagerHttpAddress = configuration.get("ozone.om.http-address");
        String ozoneManagerHttpsAddress = configuration.get("ozone.om.https-address");
        this.omSnapshotDBParentDir = reconUtils.getReconDbDir((ConfigurationSource)configuration, "ozone.recon.om.db.dir");
        HttpConfig.Policy policy = HttpConfig.getHttpPolicy((MutableConfigurationSource)configuration);
        this.omDBSnapshotUrl = "http://" + ozoneManagerHttpAddress + "/dbCheckpoint";
        if (policy.isHttpsEnabled()) {
            this.omDBSnapshotUrl = "https://" + ozoneManagerHttpsAddress + "/dbCheckpoint";
        }
        if (flushParam = configuration.getBoolean("ozone.recon.om.snapshot.task.flush.param", configuration.getBoolean("recon.om.snapshot.task.flush.param", false))) {
            this.omDBSnapshotUrl = this.omDBSnapshotUrl + "?flushBeforeCheckpoint=true";
        }
        this.reconUtils = reconUtils;
        this.omMetadataManager = omMetadataManager;
        this.reconTaskController = reconTaskController;
        this.reconTaskStatusDao = reconTaskController.getReconTaskStatusDao();
        this.ozoneManagerClient = ozoneManagerClient;
        this.configuration = configuration;
        this.metrics = OzoneManagerSyncMetrics.create();
    }

    public void registerOMDBTasks() {
        ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(OmSnapshotTaskName.OmDeltaRequest.name(), System.currentTimeMillis(), this.getCurrentOMDBSequenceNumber());
        if (!this.reconTaskStatusDao.existsById(OmSnapshotTaskName.OmDeltaRequest.name())) {
            this.reconTaskStatusDao.insert(reconTaskStatusRecord);
            LOG.info("Registered {} task ", (Object)OmSnapshotTaskName.OmDeltaRequest.name());
        }
        reconTaskStatusRecord = new ReconTaskStatus(OmSnapshotTaskName.OmSnapshotRequest.name(), System.currentTimeMillis(), this.getCurrentOMDBSequenceNumber());
        if (!this.reconTaskStatusDao.existsById(OmSnapshotTaskName.OmSnapshotRequest.name())) {
            this.reconTaskStatusDao.insert(reconTaskStatusRecord);
            LOG.info("Registered {} task ", (Object)OmSnapshotTaskName.OmSnapshotRequest.name());
        }
    }

    @Override
    public OMMetadataManager getOMMetadataManagerInstance() {
        return this.omMetadataManager;
    }

    @Override
    public void start() {
        LOG.info("Starting Ozone Manager Service Provider.");
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.registerOMDBTasks();
        try {
            this.omMetadataManager.start(this.configuration);
        }
        catch (IOException ioEx) {
            LOG.error("Error staring Recon OM Metadata Manager.", (Throwable)ioEx);
        }
        this.reconTaskController.start();
        long initialDelay = this.configuration.getTimeDuration("ozone.recon.om.snapshot.task.initial.delay", this.configuration.get("recon.om.snapshot.task.initial.delay", "1m"), TimeUnit.MILLISECONDS);
        long interval = this.configuration.getTimeDuration("ozone.recon.om.snapshot.task.interval.delay", this.configuration.get("recon.om.snapshot.task.interval.delay", "10m"), TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.syncDataFromOM();
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while syncing data from OM.", t);
            }
        }, initialDelay, interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() throws Exception {
        LOG.info("Stopping Ozone Manager Service Provider.");
        this.reconTaskController.stop();
        this.omMetadataManager.stop();
        this.scheduler.shutdownNow();
        this.metrics.unRegister();
        this.connectionFactory.destroy();
    }

    @VisibleForTesting
    public String getOzoneManagerSnapshotUrl() throws IOException {
        if (!this.configuration.getBoolean("ozone.om.ratis.enable", false)) {
            return this.omDBSnapshotUrl;
        }
        String omLeaderUrl = this.omDBSnapshotUrl;
        List serviceList = this.ozoneManagerClient.getServiceList();
        HttpConfig.Policy policy = HttpConfig.getHttpPolicy((MutableConfigurationSource)this.configuration);
        if (!serviceList.isEmpty()) {
            for (ServiceInfo info : serviceList) {
                if (!info.getNodeType().equals((Object)HddsProtos.NodeType.OM) || !info.getOmRoleInfo().hasServerRole() || !info.getOmRoleInfo().getServerRole().equals(RaftProtos.RaftPeerRole.LEADER.name())) continue;
                omLeaderUrl = (policy.isHttpsEnabled() ? "https://" + info.getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS) : "http://" + info.getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type.HTTP)) + "/dbCheckpoint";
            }
        }
        return omLeaderUrl;
    }

    private boolean isOmSpengoEnabled() {
        return this.configuration.get("ozone.om.http.auth.type", "simple").equals("kerberos");
    }

    @VisibleForTesting
    DBCheckpoint getOzoneManagerDBSnapshot() {
        String snapshotFileName = "om.snapshot.db_" + System.currentTimeMillis();
        File targetFile = new File(this.omSnapshotDBParentDir, snapshotFileName + ".tar.gz");
        try {
            SecurityUtil.doAsLoginUser(() -> {
                try (InputStream inputStream = this.reconUtils.makeHttpCall(this.connectionFactory, this.getOzoneManagerSnapshotUrl(), this.isOmSpengoEnabled()).getInputStream();){
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                }
                return null;
            });
            Path untarredDbDir = Paths.get(this.omSnapshotDBParentDir.getAbsolutePath(), snapshotFileName);
            this.reconUtils.untarCheckpointFile(targetFile, untarredDbDir);
            FileUtils.deleteQuietly((File)targetFile);
            return new RocksDBCheckpoint(untarredDbDir);
        }
        catch (IOException e) {
            LOG.error("Unable to obtain Ozone Manager DB Snapshot. ", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    boolean updateReconOmDBWithNewSnapshot() throws IOException {
        long startTime = Time.monotonicNow();
        DBCheckpoint dbSnapshot = this.getOzoneManagerDBSnapshot();
        this.metrics.updateSnapshotRequestLatency(Time.monotonicNow() - startTime);
        if (dbSnapshot != null && dbSnapshot.getCheckpointLocation() != null) {
            LOG.info("Got new checkpoint from OM : " + dbSnapshot.getCheckpointLocation());
            try {
                this.omMetadataManager.updateOmDB(dbSnapshot.getCheckpointLocation().toFile());
                return true;
            }
            catch (IOException e) {
                LOG.error("Unable to refresh Recon OM DB Snapshot. ", (Throwable)e);
            }
        } else {
            LOG.error("Null snapshot location got from OM.");
        }
        return false;
    }

    @VisibleForTesting
    void getAndApplyDeltaUpdatesFromOM(long fromSequenceNumber, OMDBUpdatesHandler omdbUpdatesHandler) throws IOException, RocksDBException {
        OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest = OzoneManagerProtocolProtos.DBUpdatesRequest.newBuilder().setSequenceNumber(fromSequenceNumber).build();
        DBUpdates dbUpdates = this.ozoneManagerClient.getDBUpdates(dbUpdatesRequest);
        if (null != dbUpdates) {
            RDBStore rocksDBStore = (RDBStore)this.omMetadataManager.getStore();
            RocksDB rocksDB = rocksDBStore.getDb();
            int numUpdates = dbUpdates.getData().size();
            LOG.info("Number of updates received from OM : {}", (Object)numUpdates);
            if (numUpdates > 0) {
                this.metrics.incrNumUpdatesInDeltaTotal(numUpdates);
            }
            for (byte[] data : dbUpdates.getData()) {
                WriteBatch writeBatch = new WriteBatch(data);
                Throwable throwable = null;
                try {
                    writeBatch.iterate((WriteBatch.Handler)omdbUpdatesHandler);
                    RDBBatchOperation rdbBatchOperation = new RDBBatchOperation(writeBatch);
                    Throwable throwable2 = null;
                    try {
                        WriteOptions wOpts = new WriteOptions();
                        Throwable throwable3 = null;
                        try {
                            rdbBatchOperation.commit(rocksDB, wOpts);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (wOpts == null) continue;
                            if (throwable3 != null) {
                                try {
                                    wOpts.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            wOpts.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (rdbBatchOperation == null) continue;
                        if (throwable2 != null) {
                            try {
                                rdbBatchOperation.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        rdbBatchOperation.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (writeBatch == null) continue;
                    if (throwable != null) {
                        try {
                            writeBatch.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    writeBatch.close();
                }
            }
        }
    }

    @VisibleForTesting
    public void syncDataFromOM() {
        LOG.info("Syncing data from Ozone Manager.");
        long currentSequenceNumber = this.getCurrentOMDBSequenceNumber();
        LOG.debug("Seq number of Recon's OM DB : {}", (Object)currentSequenceNumber);
        boolean fullSnapshot = false;
        if (currentSequenceNumber <= 0L) {
            fullSnapshot = true;
        } else {
            try (OMDBUpdatesHandler omdbUpdatesHandler = new OMDBUpdatesHandler(this.omMetadataManager);){
                LOG.info("Obtaining delta updates from Ozone Manager");
                this.getAndApplyDeltaUpdatesFromOM(currentSequenceNumber, omdbUpdatesHandler);
                ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(OmSnapshotTaskName.OmDeltaRequest.name(), System.currentTimeMillis(), this.getCurrentOMDBSequenceNumber());
                this.reconTaskStatusDao.update(reconTaskStatusRecord);
                this.reconTaskController.consumeOMEvents(new OMUpdateEventBatch(omdbUpdatesHandler.getEvents()), this.omMetadataManager);
            }
            catch (InterruptedException intEx) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.metrics.incrNumDeltaRequestsFailed();
                LOG.warn("Unable to get and apply delta updates from OM.", (Throwable)e);
                fullSnapshot = true;
            }
        }
        if (fullSnapshot) {
            try {
                this.metrics.incrNumSnapshotRequests();
                LOG.info("Obtaining full snapshot from Ozone Manager");
                boolean success = this.updateReconOmDBWithNewSnapshot();
                if (success) {
                    ReconTaskStatus reconTaskStatusRecord = new ReconTaskStatus(OmSnapshotTaskName.OmSnapshotRequest.name(), System.currentTimeMillis(), this.getCurrentOMDBSequenceNumber());
                    this.reconTaskStatusDao.update(reconTaskStatusRecord);
                    LOG.info("Calling reprocess on Recon tasks.");
                    this.reconTaskController.reInitializeTasks(this.omMetadataManager);
                }
            }
            catch (InterruptedException intEx) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.metrics.incrNumSnapshotRequestsFailed();
                LOG.error("Unable to update Recon's metadata with new OM DB. ", (Throwable)e);
            }
        }
    }

    private long getCurrentOMDBSequenceNumber() {
        return this.omMetadataManager.getLastSequenceNumberFromDB();
    }

    public OzoneManagerSyncMetrics getMetrics() {
        return this.metrics;
    }

    public static enum OmSnapshotTaskName {
        OmSnapshotRequest,
        OmDeltaRequest;

    }
}

