/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.StaleNodeHandler;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineActionHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.recon.fsck.ContainerHealthTask;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.scm.PipelineSyncTask;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerReportHandler;
import org.apache.hadoop.ozone.recon.scm.ReconDatanodeProtocolServer;
import org.apache.hadoop.ozone.recon.scm.ReconIncrementalContainerReportHandler;
import org.apache.hadoop.ozone.recon.scm.ReconNewNodeHandler;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineReportHandler;
import org.apache.hadoop.ozone.recon.scm.ReconSCMDBDefinition;
import org.apache.hadoop.ozone.recon.scm.ReconSafeModeManager;
import org.apache.hadoop.ozone.recon.scm.ReconScmTask;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.ozone.recon.spi.ContainerDBServiceProvider;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.hadoop.ozone.recon.schema.tables.daos.ReconTaskStatusDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconStorageContainerManagerFacade
implements OzoneStorageContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconStorageContainerManagerFacade.class);
    private final OzoneConfiguration ozoneConfiguration;
    private final ReconDatanodeProtocolServer datanodeProtocolServer;
    private final EventQueue eventQueue;
    private final SCMStorageConfig scmStorageConfig;
    private final DBStore dbStore;
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;
    private ReconContainerManager containerManager;
    private NetworkTopology clusterMap;
    private StorageContainerServiceProvider scmServiceProvider;
    private Set<ReconScmTask> reconScmTasks = new HashSet<ReconScmTask>();
    private SCMContainerPlacementMetrics placementMetrics;
    private PlacementPolicy containerPlacementPolicy;

    @Inject
    public ReconStorageContainerManagerFacade(OzoneConfiguration conf, StorageContainerServiceProvider scmServiceProvider, ReconTaskStatusDao reconTaskStatusDao, ContainerHealthSchemaManager containerHealthSchemaManager, ContainerDBServiceProvider containerDBServiceProvider) throws IOException {
        this.eventQueue = new EventQueue();
        this.eventQueue.setSilent(true);
        this.ozoneConfiguration = this.getReconScmConfiguration(conf);
        this.scmStorageConfig = new ReconStorageConfig(conf);
        this.clusterMap = new NetworkTopologyImpl((ConfigurationSource)conf);
        this.dbStore = DBStoreBuilder.createDBStore((ConfigurationSource)this.ozoneConfiguration, (DBDefinition)new ReconSCMDBDefinition());
        this.nodeManager = new ReconNodeManager(conf, this.scmStorageConfig, (EventPublisher)this.eventQueue, this.clusterMap, (Table<UUID, DatanodeDetails>)ReconSCMDBDefinition.NODES.getTable(this.dbStore));
        this.placementMetrics = SCMContainerPlacementMetrics.create();
        this.containerPlacementPolicy = ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)conf, (NodeManager)this.nodeManager, (NetworkTopology)this.clusterMap, (boolean)true, (SCMContainerPlacementMetrics)this.placementMetrics);
        this.datanodeProtocolServer = new ReconDatanodeProtocolServer(conf, this, (EventPublisher)this.eventQueue);
        this.pipelineManager = new ReconPipelineManager((ConfigurationSource)conf, (NodeManager)this.nodeManager, (Table<PipelineID, Pipeline>)ReconSCMDBDefinition.PIPELINES.getTable(this.dbStore), (EventPublisher)this.eventQueue);
        this.containerManager = new ReconContainerManager((ConfigurationSource)conf, (Table<ContainerID, ContainerInfo>)ReconSCMDBDefinition.CONTAINERS.getTable(this.dbStore), this.dbStore, (PipelineManager)this.pipelineManager, scmServiceProvider, containerHealthSchemaManager, containerDBServiceProvider);
        this.scmServiceProvider = scmServiceProvider;
        NodeReportHandler nodeReportHandler = new NodeReportHandler((NodeManager)this.nodeManager);
        ReconSafeModeManager safeModeManager = new ReconSafeModeManager();
        ReconPipelineReportHandler pipelineReportHandler = new ReconPipelineReportHandler(safeModeManager, (PipelineManager)this.pipelineManager, (ConfigurationSource)conf, scmServiceProvider);
        PipelineActionHandler pipelineActionHandler = new PipelineActionHandler((PipelineManager)this.pipelineManager, conf);
        StaleNodeHandler staleNodeHandler = new StaleNodeHandler((NodeManager)this.nodeManager, (PipelineManager)this.pipelineManager, conf);
        DeadNodeHandler deadNodeHandler = new DeadNodeHandler((NodeManager)this.nodeManager, (PipelineManager)this.pipelineManager, (ContainerManager)this.containerManager);
        ReconContainerReportHandler containerReportHandler = new ReconContainerReportHandler((NodeManager)this.nodeManager, (ContainerManager)this.containerManager);
        ReconIncrementalContainerReportHandler icrHandler = new ReconIncrementalContainerReportHandler((NodeManager)this.nodeManager, (ContainerManager)this.containerManager);
        CloseContainerEventHandler closeContainerHandler = new CloseContainerEventHandler((PipelineManager)this.pipelineManager, (ContainerManager)this.containerManager);
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        ReconNewNodeHandler newNodeHandler = new ReconNewNodeHandler(this.nodeManager);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.nodeManager);
        this.eventQueue.addHandler((Event)SCMEvents.NODE_REPORT, (EventHandler)nodeReportHandler);
        this.eventQueue.addHandler((Event)SCMEvents.PIPELINE_REPORT, (EventHandler)pipelineReportHandler);
        this.eventQueue.addHandler((Event)SCMEvents.PIPELINE_ACTIONS, (EventHandler)pipelineActionHandler);
        this.eventQueue.addHandler((Event)SCMEvents.STALE_NODE, (EventHandler)staleNodeHandler);
        this.eventQueue.addHandler((Event)SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.eventQueue.addHandler((Event)SCMEvents.CONTAINER_REPORT, (EventHandler)containerReportHandler);
        this.eventQueue.addHandler((Event)SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventHandler)icrHandler);
        this.eventQueue.addHandler((Event)SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        this.eventQueue.addHandler((Event)SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.eventQueue.addHandler((Event)SCMEvents.NEW_NODE, (EventHandler)newNodeHandler);
        ReconTaskConfig reconTaskConfig = (ReconTaskConfig)conf.getObject(ReconTaskConfig.class);
        this.reconScmTasks.add(new PipelineSyncTask(this.pipelineManager, scmServiceProvider, reconTaskStatusDao, reconTaskConfig));
        this.reconScmTasks.add(new ContainerHealthTask((ContainerManager)this.containerManager, reconTaskStatusDao, containerHealthSchemaManager, this.containerPlacementPolicy, reconTaskConfig));
    }

    private OzoneConfiguration getReconScmConfiguration(OzoneConfiguration configuration) {
        OzoneConfiguration reconScmConfiguration = new OzoneConfiguration((Configuration)configuration);
        Map reconScmConfigs = configuration.getPropsWithPrefix("ozone.recon.scmconfig");
        for (Map.Entry entry : reconScmConfigs.entrySet()) {
            reconScmConfiguration.set((String)entry.getKey(), (String)entry.getValue());
        }
        return reconScmConfiguration;
    }

    public void start() {
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage((String)"Recon ScmDatanodeProtocol RPC server", (InetSocketAddress)this.getDatanodeProtocolServer().getDatanodeRpcAddress()));
        }
        this.initializePipelinesFromScm();
        this.getDatanodeProtocolServer().start();
        this.reconScmTasks.forEach(ReconScmTask::start);
    }

    public void join() {
        try {
            this.getDatanodeProtocolServer().join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public void stop() {
        this.getDatanodeProtocolServer().stop();
        this.reconScmTasks.forEach(ReconScmTask::stop);
        try {
            LOG.info("Stopping SCM Event Queue.");
            this.eventQueue.close();
        }
        catch (Exception ex) {
            LOG.error("SCM Event Queue stop failed", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.nodeManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.containerManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.pipelineManager});
        LOG.info("Flushing container replica history to DB.");
        this.containerManager.flushReplicaHistoryMapToDB(true);
        try {
            this.dbStore.close();
        }
        catch (Exception e) {
            LOG.error("Can't close dbStore ", (Throwable)e);
        }
    }

    public ReconDatanodeProtocolServer getDatanodeProtocolServer() {
        return this.datanodeProtocolServer;
    }

    private void initializePipelinesFromScm() {
        try {
            List<Pipeline> pipelinesFromScm = this.scmServiceProvider.getPipelines();
            LOG.info("Obtained {} pipelines from SCM.", (Object)pipelinesFromScm.size());
            this.pipelineManager.initializePipelines(pipelinesFromScm);
        }
        catch (IOException ioEx) {
            LOG.error("Exception encountered while getting pipelines from SCM.", (Throwable)ioEx);
        }
    }

    public NodeManager getScmNodeManager() {
        return this.nodeManager;
    }

    public BlockManager getScmBlockManager() {
        return null;
    }

    public PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }

    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    public ReplicationManager getReplicationManager() {
        return null;
    }

    public InetSocketAddress getDatanodeRpcAddress() {
        return this.getDatanodeProtocolServer().getDatanodeRpcAddress();
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }
}

