/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineFactory;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconPipelineManager
extends SCMPipelineManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconPipelineManager.class);

    public ReconPipelineManager(ConfigurationSource conf, NodeManager nodeManager, Table<PipelineID, Pipeline> pipelineStore, EventPublisher eventPublisher) throws IOException {
        super(conf, nodeManager, pipelineStore, eventPublisher, new PipelineStateManager(), (PipelineFactory)new ReconPipelineFactory());
        this.initializePipelineState();
    }

    public void triggerPipelineCreation() {
    }

    protected void destroyPipeline(Pipeline pipeline) throws IOException {
        this.removePipeline(pipeline.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializePipelines(List<Pipeline> pipelinesFromScm) throws IOException {
        this.getLock().writeLock().lock();
        try {
            List pipelinesInHouse = this.getPipelines();
            LOG.info("Recon has {} pipelines in house.", (Object)pipelinesInHouse.size());
            for (Pipeline pipeline : pipelinesFromScm) {
                if (!this.containsPipeline(pipeline.getId())) {
                    LOG.info("Adding new pipeline {} from SCM.", (Object)pipeline.getId());
                    this.addPipeline(pipeline);
                } else {
                    this.getStateManager().updatePipelineState(pipeline.getId(), pipeline.getPipelineState());
                    this.getPipeline(pipeline.getId()).setCreationTimestamp(pipeline.getCreationTimestamp());
                }
                this.removeInvalidPipelines(pipelinesFromScm);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidPipelines(List<Pipeline> pipelinesFromScm) {
        this.getLock().writeLock().lock();
        try {
            List pipelinesInHouse = this.getPipelines();
            List<Pipeline> invalidPipelines = pipelinesInHouse.stream().filter(p -> !pipelinesFromScm.contains(p)).collect(Collectors.toList());
            invalidPipelines.forEach(p -> {
                PipelineID pipelineID = p.getId();
                if (!p.getPipelineState().equals((Object)Pipeline.PipelineState.CLOSED)) {
                    try {
                        this.getStateManager().updatePipelineState(pipelineID, Pipeline.PipelineState.CLOSED);
                    }
                    catch (PipelineNotFoundException e) {
                        LOG.warn("Pipeline {} not found while updating state. ", (Object)p.getId(), (Object)e);
                    }
                }
                try {
                    LOG.info("Removing invalid pipeline {} from Recon.", (Object)pipelineID);
                    this.finalizeAndDestroyPipeline((Pipeline)p, false);
                }
                catch (IOException e) {
                    LOG.warn("Unable to remove pipeline {}", (Object)pipelineID, (Object)e);
                }
            });
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @VisibleForTesting
    void addPipeline(Pipeline pipeline) throws IOException {
        this.getLock().writeLock().lock();
        try {
            this.getPipelineStore().put((Object)pipeline.getId(), (Object)pipeline);
            this.getStateManager().addPipeline(pipeline);
            this.getNodeManager().addPipeline(pipeline);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }
}

