/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconContainerReportHandler
extends ContainerReportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReconContainerReportHandler.class);

    public ReconContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager) {
        super(nodeManager, containerManager);
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport();
        ReconContainerManager containerManager = (ReconContainerManager)this.getContainerManager();
        List reportsList = containerReport.getReportsList();
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto containerReplicaProto : reportsList) {
            ContainerID id = ContainerID.valueof((long)containerReplicaProto.getContainerID());
            try {
                containerManager.checkAndAddNewContainer(id, containerReplicaProto.getState(), reportFromDatanode.getDatanodeDetails());
            }
            catch (IOException ioEx) {
                LOG.error("Exception while checking and adding new container.", (Throwable)ioEx);
            }
            LOG.debug("Got container report for containerID {} ", (Object)containerReplicaProto.getContainerID());
        }
        super.onMessage(reportFromDatanode, publisher);
    }
}

