/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.persistence.ContainerHistory;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistory;
import org.apache.hadoop.ozone.recon.scm.ReconSCMDBDefinition;
import org.apache.hadoop.ozone.recon.spi.ContainerDBServiceProvider;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconContainerManager
extends SCMContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconContainerManager.class);
    private final StorageContainerServiceProvider scmClient;
    private final ContainerHealthSchemaManager containerHealthSchemaManager;
    private final ContainerDBServiceProvider cdbServiceProvider;
    private final Table<UUID, DatanodeDetails> nodeDB;
    private final Map<Long, Map<UUID, ContainerReplicaHistory>> replicaHistoryMap;

    public ReconContainerManager(ConfigurationSource conf, Table<ContainerID, ContainerInfo> containerStore, DBStore batchHandler, PipelineManager pipelineManager, StorageContainerServiceProvider scm, ContainerHealthSchemaManager containerHealthSchemaManager, ContainerDBServiceProvider containerDBServiceProvider) throws IOException {
        super(conf, containerStore, (BatchOperationHandler)batchHandler, pipelineManager);
        this.scmClient = scm;
        this.containerHealthSchemaManager = containerHealthSchemaManager;
        this.cdbServiceProvider = containerDBServiceProvider;
        this.nodeDB = ReconSCMDBDefinition.NODES.getTable(batchHandler);
        this.replicaHistoryMap = new ConcurrentHashMap<Long, Map<UUID, ContainerReplicaHistory>>();
    }

    public void checkAndAddNewContainer(ContainerID containerID, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState, DatanodeDetails datanodeDetails) throws IOException {
        if (!this.exists(containerID)) {
            LOG.info("New container {} got from {}.", (Object)containerID, (Object)datanodeDetails.getHostName());
            ContainerWithPipeline containerWithPipeline = this.scmClient.getContainerWithPipeline(containerID.getId());
            LOG.debug("Verified new container from SCM {}, {} ", (Object)containerID, (Object)containerWithPipeline.getPipeline().getId());
            if (!this.exists(containerID)) {
                this.addNewContainer(containerID.getId(), containerWithPipeline);
            }
        } else {
            ContainerInfo containerInfo = this.getContainer(containerID);
            if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN) && !replicaState.equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN) && this.isHealthy(replicaState)) {
                LOG.info("Container {} has state OPEN, but Replica has State {}.", (Object)containerID, (Object)replicaState);
                this.updateContainerState(containerID, HddsProtos.LifeCycleEvent.FINALIZE);
            }
        }
    }

    private boolean isHealthy(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState) {
        return replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.INVALID && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED;
    }

    public void addNewContainer(long containerId, ContainerWithPipeline containerWithPipeline) throws IOException {
        ContainerInfo containerInfo = containerWithPipeline.getContainerInfo();
        this.getLock().lock();
        try {
            boolean success = false;
            if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                PipelineID pipelineID = containerWithPipeline.getPipeline().getId();
                if (this.getPipelineManager().containsPipeline(pipelineID)) {
                    this.getContainerStateManager().addContainerInfo(containerId, containerInfo, this.getPipelineManager(), containerWithPipeline.getPipeline());
                    success = true;
                } else {
                    LOG.warn(String.format("Pipeline %s not found. Cannot add container %s", pipelineID, containerInfo.containerID()));
                }
            } else {
                this.getContainerStateManager().addContainerInfo(containerId, containerInfo, this.getPipelineManager(), null);
                success = true;
            }
            if (success) {
                this.addContainerToDB(containerInfo);
                LOG.info("Successfully added container {} to Recon.", (Object)containerInfo.containerID());
            }
        }
        catch (IOException ex) {
            LOG.info("Exception while adding container {} .", (Object)containerInfo.containerID(), (Object)ex);
            this.getPipelineManager().removeContainerFromPipeline(containerInfo.getPipelineID(), new ContainerID(containerInfo.getContainerID()));
            throw ex;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void updateContainerReplica(ContainerID containerID, ContainerReplica replica) throws ContainerNotFoundException {
        super.updateContainerReplica(containerID, replica);
        final long currTime = System.currentTimeMillis();
        long id = containerID.getId();
        DatanodeDetails dnInfo = replica.getDatanodeDetails();
        final UUID uuid = dnInfo.getUuid();
        Map<UUID, ContainerReplicaHistory> replicaLastSeenMap = this.replicaHistoryMap.get(id);
        boolean flushToDB = false;
        if (replicaLastSeenMap == null) {
            this.replicaHistoryMap.putIfAbsent(id, (Map<UUID, ContainerReplicaHistory>)new ConcurrentHashMap<UUID, ContainerReplicaHistory>(){
                {
                    this.put(uuid, new ContainerReplicaHistory(uuid, currTime, currTime));
                }
            });
            flushToDB = true;
        } else {
            ContainerReplicaHistory ts = replicaLastSeenMap.get(uuid);
            if (ts == null) {
                replicaLastSeenMap.put(uuid, new ContainerReplicaHistory(uuid, currTime, currTime));
                flushToDB = true;
            } else {
                ts.setLastSeenTime(currTime);
            }
        }
        if (flushToDB) {
            this.upsertContainerHistory(id, uuid, currTime);
        }
    }

    public void removeContainerReplica(ContainerID containerID, ContainerReplica replica) throws ContainerNotFoundException, ContainerReplicaNotFoundException {
        ContainerReplicaHistory ts;
        super.removeContainerReplica(containerID, replica);
        long id = containerID.getId();
        DatanodeDetails dnInfo = replica.getDatanodeDetails();
        UUID uuid = dnInfo.getUuid();
        Map<UUID, ContainerReplicaHistory> replicaLastSeenMap = this.replicaHistoryMap.get(id);
        if (replicaLastSeenMap != null && (ts = replicaLastSeenMap.get(uuid)) != null) {
            this.upsertContainerHistory(id, uuid, ts.getLastSeenTime());
            replicaLastSeenMap.remove(uuid);
        }
    }

    @VisibleForTesting
    public ContainerHealthSchemaManager getContainerSchemaManager() {
        return this.containerHealthSchemaManager;
    }

    @VisibleForTesting
    public Map<Long, Map<UUID, ContainerReplicaHistory>> getReplicaHistoryMap() {
        return this.replicaHistoryMap;
    }

    public List<ContainerHistory> getAllContainerHistory(long containerID) {
        Map<UUID, ContainerReplicaHistory> replicaLastSeenMap;
        Map<UUID, ContainerReplicaHistory> resMap;
        try {
            resMap = this.cdbServiceProvider.getContainerReplicaHistory(containerID);
        }
        catch (IOException ex) {
            resMap = new HashMap<UUID, ContainerReplicaHistory>();
            LOG.debug("Unable to retrieve container replica history from RDB.");
        }
        if (this.replicaHistoryMap != null && (replicaLastSeenMap = this.replicaHistoryMap.get(containerID)) != null) {
            Map<UUID, ContainerReplicaHistory> finalResMap = resMap;
            replicaLastSeenMap.forEach((k, v) -> finalResMap.merge((UUID)k, (ContainerReplicaHistory)v, (old, latest) -> latest));
            resMap = finalResMap;
        }
        ArrayList<ContainerHistory> resList = new ArrayList<ContainerHistory>();
        for (Map.Entry<UUID, ContainerReplicaHistory> entry : resMap.entrySet()) {
            UUID uuid = entry.getKey();
            String hostname = "N/A";
            if (this.nodeDB != null) {
                try {
                    DatanodeDetails dnDetails = (DatanodeDetails)this.nodeDB.get((Object)uuid);
                    if (dnDetails != null) {
                        hostname = dnDetails.getHostName();
                    }
                }
                catch (IOException ex) {
                    LOG.debug("Unable to retrieve from NODES table of node {}. {}", (Object)uuid, (Object)ex.getMessage());
                }
            }
            long firstSeenTime = entry.getValue().getFirstSeenTime();
            long lastSeenTime = entry.getValue().getLastSeenTime();
            resList.add(new ContainerHistory(containerID, uuid.toString(), hostname, firstSeenTime, lastSeenTime));
        }
        return resList;
    }

    public List<ContainerHistory> getLatestContainerHistory(long containerID, int limit) {
        List<ContainerHistory> res = this.getAllContainerHistory(containerID);
        res.sort(Comparator.comparingLong(ContainerHistory::getLastSeenTime).reversed());
        return res.stream().limit(limit).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushReplicaHistoryMapToDB(boolean clearMap) {
        if (this.replicaHistoryMap == null) {
            return;
        }
        Map<Long, Map<UUID, ContainerReplicaHistory>> map = this.replicaHistoryMap;
        synchronized (map) {
            try {
                this.cdbServiceProvider.batchStoreContainerReplicaHistory(this.replicaHistoryMap);
            }
            catch (IOException e) {
                LOG.debug("Error flushing container replica history to DB. {}", (Object)e.getMessage());
            }
            if (clearMap) {
                this.replicaHistoryMap.clear();
            }
        }
    }

    public void upsertContainerHistory(long containerID, UUID uuid, long time) {
        try {
            Map<UUID, ContainerReplicaHistory> tsMap = this.cdbServiceProvider.getContainerReplicaHistory(containerID);
            ContainerReplicaHistory ts = tsMap.get(uuid);
            if (ts == null) {
                tsMap.put(uuid, new ContainerReplicaHistory(uuid, time, time));
            } else {
                ts.setLastSeenTime(time);
            }
            this.cdbServiceProvider.storeContainerReplicaHistory(containerID, tsMap);
        }
        catch (IOException e) {
            LOG.debug("Error on DB operations. {}", (Object)e.getMessage());
        }
    }

    public Table<UUID, DatanodeDetails> getNodeDB() {
        return this.nodeDB;
    }
}

