/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;

public final class ClusterStateResponse {
    @JsonProperty(value="pipelines")
    private int pipelines;
    @JsonProperty(value="totalDatanodes")
    private int totalDatanodes;
    @JsonProperty(value="healthyDatanodes")
    private int healthyDatanodes;
    @JsonProperty(value="storageReport")
    private DatanodeStorageReport storageReport;
    @JsonProperty(value="containers")
    private int containers;
    @JsonProperty(value="volumes")
    private long volumes;
    @JsonProperty(value="buckets")
    private long buckets;
    @JsonProperty(value="keys")
    private long keys;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ClusterStateResponse(Builder b) {
        this.buckets = b.buckets;
        this.keys = b.keys;
        this.pipelines = b.pipelines;
        this.volumes = b.volumes;
        this.totalDatanodes = b.totalDatanodes;
        this.healthyDatanodes = b.healthyDatanodes;
        this.storageReport = b.storageReport;
        this.containers = b.containers;
    }

    public int getPipelines() {
        return this.pipelines;
    }

    public int getTotalDatanodes() {
        return this.totalDatanodes;
    }

    public int getHealthyDatanodes() {
        return this.healthyDatanodes;
    }

    public DatanodeStorageReport getStorageReport() {
        return this.storageReport;
    }

    public int getContainers() {
        return this.containers;
    }

    public long getVolumes() {
        return this.volumes;
    }

    public long getBuckets() {
        return this.buckets;
    }

    public long getKeys() {
        return this.keys;
    }

    public static final class Builder {
        private int pipelines = 0;
        private int totalDatanodes = 0;
        private int healthyDatanodes = 0;
        private DatanodeStorageReport storageReport;
        private int containers = 0;
        private long volumes = 0L;
        private long buckets = 0L;
        private long keys = 0L;

        public Builder setPipelines(int pipelines) {
            this.pipelines = pipelines;
            return this;
        }

        public Builder setTotalDatanodes(int totalDatanodes) {
            this.totalDatanodes = totalDatanodes;
            return this;
        }

        public Builder setHealthyDatanodes(int healthyDatanodes) {
            this.healthyDatanodes = healthyDatanodes;
            return this;
        }

        public Builder setStorageReport(DatanodeStorageReport storageReport) {
            this.storageReport = storageReport;
            return this;
        }

        public Builder setContainers(int containers) {
            this.containers = containers;
            return this;
        }

        public Builder setVolumes(long volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder setBuckets(long buckets) {
            this.buckets = buckets;
            return this;
        }

        public Builder setKeys(long keys) {
            this.keys = keys;
            return this;
        }

        public ClusterStateResponse build() {
            Preconditions.checkNotNull((Object)this.storageReport);
            return new ClusterStateResponse(this);
        }
    }
}

