/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hadoop.ozone.recon.schema.UtilizationSchemaDefinition;
import org.hadoop.ozone.recon.schema.tables.FileCountBySizeTable;
import org.hadoop.ozone.recon.schema.tables.daos.FileCountBySizeDao;
import org.hadoop.ozone.recon.schema.tables.pojos.FileCountBySize;
import org.jooq.DSLContext;
import org.jooq.Record3;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;

@Path(value="/utilization")
@Produces(value={"application/json"})
public class UtilizationEndpoint {
    private FileCountBySizeDao fileCountBySizeDao;
    private UtilizationSchemaDefinition utilizationSchemaDefinition;

    @Inject
    public UtilizationEndpoint(FileCountBySizeDao fileCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition) {
        this.utilizationSchemaDefinition = utilizationSchemaDefinition;
        this.fileCountBySizeDao = fileCountBySizeDao;
    }

    @GET
    @Path(value="/fileCount")
    public Response getFileCounts(@QueryParam(value="volume") String volume, @QueryParam(value="bucket") String bucket, @QueryParam(value="fileSize") long fileSize) {
        Record3 recordToFind;
        FileCountBySize record;
        DSLContext dslContext = this.utilizationSchemaDefinition.getDSLContext();
        List<Object> resultSet = volume != null && bucket != null && fileSize > 0L ? ((record = (FileCountBySize)this.fileCountBySizeDao.findById(recordToFind = dslContext.newRecord(FileCountBySizeTable.FILE_COUNT_BY_SIZE.VOLUME, FileCountBySizeTable.FILE_COUNT_BY_SIZE.BUCKET, FileCountBySizeTable.FILE_COUNT_BY_SIZE.FILE_SIZE).value1((Object)volume).value2((Object)bucket).value3((Object)fileSize))) != null ? Collections.singletonList(record) : Collections.emptyList()) : (volume != null && bucket != null ? dslContext.select(new SelectFieldOrAsterisk[0]).from((TableLike)FileCountBySizeTable.FILE_COUNT_BY_SIZE).where(FileCountBySizeTable.FILE_COUNT_BY_SIZE.VOLUME.eq((Object)volume)).and(FileCountBySizeTable.FILE_COUNT_BY_SIZE.BUCKET.eq((Object)bucket)).fetchInto(FileCountBySize.class) : (volume != null ? this.fileCountBySizeDao.fetchByVolume(volume) : this.fileCountBySizeDao.findAll()));
        return Response.ok((Object)resultSet).build();
    }
}

