/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.types.ClusterStateResponse;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.tasks.TableCountTask;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusterState")
@Produces(value={"application/json"})
public class ClusterStateEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStateEndpoint.class);
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;
    private ReconContainerManager containerManager;
    private GlobalStatsDao globalStatsDao;

    @Inject
    ClusterStateEndpoint(OzoneStorageContainerManager reconSCM, GlobalStatsDao globalStatsDao) {
        this.nodeManager = (ReconNodeManager)reconSCM.getScmNodeManager();
        this.pipelineManager = (ReconPipelineManager)reconSCM.getPipelineManager();
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.globalStatsDao = globalStatsDao;
    }

    @GET
    public Response getClusterState() {
        List datanodeDetails = this.nodeManager.getAllNodes();
        int containers = this.containerManager.getContainerIDs().size();
        int pipelines = this.pipelineManager.getPipelines().size();
        int healthyDatanodes = this.nodeManager.getNodeCount(NodeStatus.inServiceHealthy());
        SCMNodeStat stats = this.nodeManager.getStats();
        DatanodeStorageReport storageReport = new DatanodeStorageReport(stats.getCapacity().get(), stats.getScmUsed().get(), stats.getRemaining().get());
        ClusterStateResponse.Builder builder = ClusterStateResponse.newBuilder();
        GlobalStats volumeRecord = (GlobalStats)this.globalStatsDao.findById(TableCountTask.getRowKeyFromTable("volumeTable"));
        GlobalStats bucketRecord = (GlobalStats)this.globalStatsDao.findById(TableCountTask.getRowKeyFromTable("bucketTable"));
        GlobalStats keyRecord = (GlobalStats)this.globalStatsDao.findById(TableCountTask.getRowKeyFromTable("keyTable"));
        if (volumeRecord != null) {
            builder.setVolumes(volumeRecord.getValue());
        }
        if (bucketRecord != null) {
            builder.setBuckets(bucketRecord.getValue());
        }
        if (keyRecord != null) {
            builder.setKeys(keyRecord.getValue());
        }
        ClusterStateResponse response = builder.setStorageReport(storageReport).setPipelines(pipelines).setContainers(containers).setTotalDatanodes(datanodeDetails.size()).setHealthyDatanodes(healthyDatanodes).build();
        return Response.ok((Object)response).build();
    }
}

