/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.environment.util.SecurityActions;
import org.jboss.weld.resources.spi.ResourceLoader;

public final class DevelopmentMode {
    public static final String PROBE_EXTENSION_CLASS_NAME = "org.jboss.weld.probe.ProbeExtension";
    public static final String PROBE_FILTER_CLASS_NAME = "org.jboss.weld.probe.ProbeFilter";

    private DevelopmentMode() {
    }

    public static Extension getProbeExtension(ResourceLoader resourceLoader) {
        try {
            Class probeExtensionClass = Reflections.loadClass(resourceLoader, PROBE_EXTENSION_CLASS_NAME);
            if (probeExtensionClass == null) {
                throw CommonLogger.LOG.probeComponentNotFoundOnClasspath(PROBE_EXTENSION_CLASS_NAME);
            }
            return (Extension)SecurityActions.newInstance(probeExtensionClass);
        }
        catch (Exception e) {
            throw CommonLogger.LOG.unableToInitializeProbeComponent(e.getMessage(), e);
        }
    }
}

