/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc;

import javax.annotation.Nullable;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.grpc.Attributes;
import org.apache.ratis.thirdparty.io.grpc.CallOptions;
import org.apache.ratis.thirdparty.io.grpc.Internal;
import org.apache.ratis.thirdparty.io.grpc.LoadBalancer;
import org.apache.ratis.thirdparty.io.grpc.Status;

@Internal
public abstract class InternalConfigSelector {
    public static final Attributes.Key<InternalConfigSelector> KEY = Attributes.Key.create("org.apache.ratis.thirdparty.io.grpc.config-selector");

    public abstract Result selectConfig(LoadBalancer.PickSubchannelArgs var1);

    public static final class Result {
        private final Status status;
        @Nullable
        private final Object config;
        @Nullable
        private final CallOptions callOptions;
        @Nullable
        private final Runnable committedCallback;

        private Result(Status status, Object config, CallOptions callOptions, Runnable committedCallback) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.config = config;
            this.callOptions = callOptions;
            this.committedCallback = committedCallback;
        }

        public static Result forError(Status status) {
            Preconditions.checkArgument(!status.isOk(), "status is OK");
            return new Result(status, null, null, null);
        }

        public Status getStatus() {
            return this.status;
        }

        @Nullable
        public Object getConfig() {
            return this.config;
        }

        @Nullable
        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        @Nullable
        public Runnable getCommittedCallback() {
            return this.committedCallback;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Object config;
            private CallOptions callOptions;
            private Runnable committedCallback;

            private Builder() {
            }

            public Builder setConfig(Object config) {
                this.config = Preconditions.checkNotNull(config, "config");
                return this;
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
                return this;
            }

            public Builder setCommittedCallback(@Nullable Runnable committedCallback) {
                this.committedCallback = committedCallback;
                return this;
            }

            public Result build() {
                Preconditions.checkState(this.config != null, "config is not set");
                Preconditions.checkState(this.callOptions != null, "callOptions is not set");
                return new Result(Status.OK, this.config, this.callOptions, this.committedCallback);
            }
        }
    }
}

