/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.ParseException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OFSPath {
    private String authority = "";
    private String volumeName = "";
    private String bucketName = "";
    private String mountName = "";
    private String keyName = "";
    private static final String OFS_MOUNT_NAME_TMP = "tmp";
    @VisibleForTesting
    public static final String OFS_MOUNT_TMP_VOLUMENAME = "tmp";

    public OFSPath(Path path) {
        this.initOFSPath(path.toUri());
    }

    public OFSPath(String pathStr) {
        try {
            this.initOFSPath(new URI(pathStr));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initOFSPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.toLowerCase().equals("ofs")) {
            throw new ParseException("Can't parse schemes other than ofs://.");
        }
        this.authority = uri.getAuthority() == null ? "" : uri.getAuthority();
        String pathStr = uri.getPath();
        StringTokenizer token = new StringTokenizer(pathStr, "/");
        int numToken = token.countTokens();
        if (numToken > 0) {
            String firstToken = token.nextToken();
            if (firstToken.equals("tmp")) {
                this.mountName = firstToken;
                this.volumeName = "tmp";
                try {
                    this.bucketName = OFSPath.getTempMountBucketNameOfCurrentUser();
                }
                catch (IOException ex) {
                    throw new ParseException("Failed to get temp bucket name for current user.");
                }
            } else if (numToken >= 2) {
                this.volumeName = firstToken;
                this.bucketName = token.nextToken();
            } else {
                this.volumeName = firstToken;
            }
        }
        if (token.hasMoreTokens()) {
            this.keyName = token.nextToken("").substring(1);
        }
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getMountName() {
        return this.mountName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String toString() {
        Preconditions.checkNotNull((Object)this.authority);
        StringBuilder sb = new StringBuilder();
        if (!this.isMount()) {
            sb.append(this.volumeName);
            sb.append("/");
            if (!this.bucketName.isEmpty()) {
                sb.append(this.bucketName);
                sb.append("/");
            }
        } else {
            sb.append(this.mountName);
            sb.append("/");
        }
        if (!this.keyName.isEmpty()) {
            sb.append(this.keyName);
        }
        if (this.authority.isEmpty()) {
            sb.insert(0, "/");
            return sb.toString();
        }
        Path pathWithSchemeAuthority = new Path("ofs", this.authority, "/");
        sb.insert(0, pathWithSchemeAuthority.toString());
        return sb.toString();
    }

    public String getNonKeyPath() {
        return "/" + this.getNonKeyPathNoPrefixDelim();
    }

    public String getNonKeyPathNoPrefixDelim() {
        if (this.isMount()) {
            return this.mountName;
        }
        return this.volumeName + "/" + this.bucketName;
    }

    public boolean isMount() {
        return this.mountName.length() > 0;
    }

    private static boolean isInSameBucketAsInternal(OFSPath p1, OFSPath p2) {
        return p1.getVolumeName().equals(p2.getVolumeName()) && p1.getBucketName().equals(p2.getBucketName());
    }

    public boolean isInSameBucketAs(OFSPath p2) {
        return OFSPath.isInSameBucketAsInternal(this, p2);
    }

    public boolean isRoot() {
        return this.getVolumeName().isEmpty() && this.getBucketName().isEmpty();
    }

    public boolean isVolume() {
        return this.getBucketName().isEmpty() && !this.getVolumeName().isEmpty();
    }

    public boolean isBucket() {
        return this.getKeyName().isEmpty() && !this.getBucketName().isEmpty() && !this.getVolumeName().isEmpty();
    }

    public boolean isKey() {
        return !this.getKeyName().isEmpty();
    }

    private static String md5Hex(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            BigInteger bigInt = new BigInteger(1, digest);
            StringBuilder sb = new StringBuilder(bigInt.toString(16));
            while (sb.length() < 32) {
                sb.insert(0, "0");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    @VisibleForTesting
    static String getTempMountBucketName(String username) {
        Preconditions.checkNotNull((Object)username);
        return OFSPath.md5Hex(username);
    }

    public static String getTempMountBucketNameOfCurrentUser() throws IOException {
        String username = UserGroupInformation.getCurrentUser().getUserName();
        return OFSPath.getTempMountBucketName(username);
    }

    public Path getTrashRoot() {
        if (!this.isKey()) {
            throw new RuntimeException("Volume or bucket doesn't have trash root.");
        }
        try {
            String username = UserGroupInformation.getCurrentUser().getUserName();
            Path pathRoot = new Path("ofs", this.authority, "/");
            Path pathToVolume = new Path(pathRoot, this.volumeName);
            Path pathToBucket = new Path(pathToVolume, this.bucketName);
            Path pathToTrash = new Path(pathToBucket, ".Trash");
            return new Path(pathToTrash, username);
        }
        catch (IOException ex) {
            throw new RuntimeException("getTrashRoot failed.", ex);
        }
    }
}

