/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.ratis.client.api.AdminApi;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.rpc.CallId;

class AdminImpl
implements AdminApi {
    private final RaftClientImpl client;

    AdminImpl(RaftClientImpl client) {
        this.client = Objects.requireNonNull(client, "client == null");
    }

    @Override
    public RaftClientReply setConfiguration(List<RaftPeer> peersInNewConf) throws IOException {
        Objects.requireNonNull(peersInNewConf, "peersInNewConf == null");
        long callId = CallId.getAndIncrement();
        this.client.getClientRpc().addRaftPeers(peersInNewConf);
        return this.client.io().sendRequestWithRetry(() -> new SetConfigurationRequest(this.client.getId(), this.client.getLeaderId(), this.client.getGroupId(), callId, peersInNewConf));
    }

    @Override
    public RaftClientReply transferLeadership(RaftPeerId newLeader, long timeoutMs) throws IOException {
        Objects.requireNonNull(newLeader, "newLeader == null");
        long callId = CallId.getAndIncrement();
        return this.client.io().sendRequestWithRetry(() -> new TransferLeadershipRequest(this.client.getId(), this.client.getLeaderId(), this.client.getGroupId(), callId, newLeader, timeoutMs));
    }
}

