/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class CreatePipelineCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto> {
    private static final Integer HIGH_PRIORITY = 1;
    private static final Integer LOW_PRIORITY = 0;
    private final PipelineID pipelineID;
    private final HddsProtos.ReplicationFactor factor;
    private final HddsProtos.ReplicationType type;
    private final List<DatanodeDetails> nodelist;
    private final List<Integer> priorityList;

    public CreatePipelineCommand(PipelineID pipelineID, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> datanodeList) {
        this.pipelineID = pipelineID;
        this.factor = factor;
        this.type = type;
        this.nodelist = datanodeList;
        this.priorityList = datanodeList.size() == XceiverServerRatis.getDefaultPriorityList().size() ? XceiverServerRatis.getDefaultPriorityList() : new ArrayList<Integer>(Collections.nCopies(datanodeList.size(), 0));
    }

    public CreatePipelineCommand(PipelineID pipelineID, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> datanodeList, DatanodeDetails suggestedLeader) {
        this.pipelineID = pipelineID;
        this.factor = factor;
        this.type = type;
        this.nodelist = datanodeList;
        this.priorityList = new ArrayList<Integer>();
        this.initPriorityList(datanodeList, suggestedLeader);
    }

    private void initPriorityList(List<DatanodeDetails> dns, DatanodeDetails suggestedLeader) {
        for (DatanodeDetails dn : dns) {
            if (dn.equals((Object)suggestedLeader)) {
                this.priorityList.add(HIGH_PRIORITY);
                continue;
            }
            this.priorityList.add(LOW_PRIORITY);
        }
    }

    public CreatePipelineCommand(long cmdId, PipelineID pipelineID, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> datanodeList, List<Integer> priorityList) {
        super(cmdId);
        this.pipelineID = pipelineID;
        this.factor = factor;
        this.type = type;
        this.nodelist = datanodeList;
        this.priorityList = priorityList;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.createPipelineCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto getProto() {
        return StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto.newBuilder().setCmdId(this.getId()).setPipelineID(this.pipelineID.getProtobuf()).setFactor(this.factor).setType(this.type).addAllDatanode((Iterable)this.nodelist.stream().map(DatanodeDetails::getProtoBufMessage).collect(Collectors.toList())).addAllPriority(this.priorityList).build();
    }

    public static CreatePipelineCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto createPipelineProto) {
        Preconditions.checkNotNull((Object)createPipelineProto);
        return new CreatePipelineCommand(createPipelineProto.getCmdId(), PipelineID.getFromProtobuf((HddsProtos.PipelineID)createPipelineProto.getPipelineID()), createPipelineProto.getType(), createPipelineProto.getFactor(), createPipelineProto.getDatanodeList().stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList()), createPipelineProto.getPriorityList());
    }

    public PipelineID getPipelineID() {
        return this.pipelineID;
    }

    public List<DatanodeDetails> getNodeList() {
        return this.nodelist;
    }

    public List<Integer> getPriorityList() {
        return this.priorityList;
    }

    public HddsProtos.ReplicationType getReplicationType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }
}

