/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.GrpcServerInterceptor;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationService;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptors;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.ClientAuth;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationServer {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationServer.class);
    private Server server;
    private SecurityConfig secConf;
    private CertificateClient caClient;
    private ContainerController controller;
    private int port;

    public ReplicationServer(ContainerController controller, ReplicationConfig replicationConfig, SecurityConfig secConf, CertificateClient caClient) {
        this.secConf = secConf;
        this.caClient = caClient;
        this.controller = controller;
        this.port = replicationConfig.getPort();
        this.init();
    }

    public void init() {
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).maxInboundMessageSize(0x2000000).addService(ServerInterceptors.intercept((BindableService)new GrpcReplicationService(new OnDemandContainerReplicationSource(this.controller)), (ServerInterceptor[])new ServerInterceptor[]{new GrpcServerInterceptor()}));
        if (this.secConf.isSecurityEnabled()) {
            try {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.caClient.getPrivateKey(), (X509Certificate[])new X509Certificate[]{this.caClient.getCertificate()});
                sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)this.secConf.getGrpcSslProvider());
                sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                sslContextBuilder.trustManager(new X509Certificate[]{this.caClient.getCACertificate()});
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException ex) {
                throw new IllegalArgumentException("Unable to setup TLS for secure datanode replication GRPC endpoint.", ex);
            }
        }
        this.server = nettyServerBuilder.build();
    }

    public void start() throws IOException {
        this.server.start();
        if (this.port == 0) {
            LOG.info("{} is started using port {}", (Object)this.getClass().getSimpleName(), (Object)this.server.getPort());
        }
        this.port = this.server.getPort();
    }

    public void stop() {
        try {
            this.server.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOG.warn("{} couldn't be stopped gracefully", (Object)this.getClass().getSimpleName());
        }
    }

    public int getPort() {
        return this.port;
    }

    @ConfigGroup(prefix="hdds.datanode.replication")
    public static final class ReplicationConfig {
        @Config(key="port", defaultValue="9886", description="Port used for the server2server replication server", tags={ConfigTag.MANAGEMENT})
        private int port;

        public int getPort() {
            return this.port;
        }

        public ReplicationConfig setPort(int portParam) {
            this.port = portParam;
            return this;
        }
    }
}

