/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.security.token.BlockTokenVerifier;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerGrpc;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.BlockDeletingService;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerDataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerMetadataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScrubberConfiguration;
import org.apache.hadoop.ozone.container.replication.ReplicationServer;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneContainer.class);
    private final HddsDispatcher hddsDispatcher;
    private final Map<ContainerProtos.ContainerType, Handler> handlers;
    private final ConfigurationSource config;
    private final MutableVolumeSet volumeSet;
    private final ContainerSet containerSet;
    private final XceiverServerSpi writeChannel;
    private final XceiverServerSpi readChannel;
    private final ContainerController controller;
    private ContainerMetadataScanner metadataScanner;
    private List<ContainerDataScanner> dataScanners;
    private final BlockDeletingService blockDeletingService;
    private final GrpcTlsConfig tlsClientConfig;
    private final ReplicationServer replicationServer;
    private DatanodeDetails datanodeDetails;

    public OzoneContainer(DatanodeDetails datanodeDetails, ConfigurationSource conf, StateContext context, CertificateClient certClient) throws IOException {
        this.config = conf;
        this.datanodeDetails = datanodeDetails;
        this.volumeSet = new MutableVolumeSet(datanodeDetails.getUuidString(), conf);
        this.volumeSet.setFailedVolumeListener(this::handleVolumeFailures);
        this.containerSet = new ContainerSet();
        this.metadataScanner = null;
        this.buildContainerSet();
        ContainerMetrics metrics = ContainerMetrics.create(conf);
        this.handlers = Maps.newHashMap();
        Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender = containerReplicaProto -> {
            StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto icr = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.newBuilder().addReport(containerReplicaProto).build();
            context.addReport((GeneratedMessage)icr);
            context.getParent().triggerHeartbeat();
        };
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            this.handlers.put(containerType, Handler.getHandlerForContainerType(containerType, conf, context.getParent().getDatanodeDetails().getUuidString(), this.containerSet, this.volumeSet, metrics, icrSender));
        }
        SecurityConfig secConf = new SecurityConfig(conf);
        this.hddsDispatcher = new HddsDispatcher(this.config, this.containerSet, this.volumeSet, this.handlers, context, metrics, (TokenVerifier)(secConf.isBlockTokenEnabled() ? new BlockTokenVerifier(secConf, certClient) : null));
        this.controller = new ContainerController(this.containerSet, this.handlers);
        this.writeChannel = XceiverServerRatis.newXceiverServerRatis(datanodeDetails, this.config, this.hddsDispatcher, this.controller, certClient, context);
        this.replicationServer = new ReplicationServer(this.controller, (ReplicationServer.ReplicationConfig)conf.getObject(ReplicationServer.ReplicationConfig.class), secConf, certClient);
        this.readChannel = new XceiverServerGrpc(datanodeDetails, this.config, this.hddsDispatcher, certClient);
        Duration svcInterval = ((DatanodeConfiguration)conf.getObject(DatanodeConfiguration.class)).getBlockDeletionInterval();
        long serviceTimeout = this.config.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new BlockDeletingService(this, svcInterval.toMillis(), serviceTimeout, TimeUnit.MILLISECONDS, this.config);
        this.tlsClientConfig = RatisHelper.createTlsClientConfig((SecurityConfig)secConf, (X509Certificate)(certClient != null ? certClient.getCACertificate() : null));
    }

    public GrpcTlsConfig getTlsClientConfig() {
        return this.tlsClientConfig;
    }

    private void buildContainerSet() {
        Iterator<HddsVolume> volumeSetIterator = this.volumeSet.getVolumesList().iterator();
        ArrayList<Thread> volumeThreads = new ArrayList<Thread>();
        long startTime = System.currentTimeMillis();
        while (volumeSetIterator.hasNext()) {
            HddsVolume volume = volumeSetIterator.next();
            Thread thread = new Thread(new ContainerReader(this.volumeSet, volume, this.containerSet, this.config));
            thread.start();
            volumeThreads.add(thread);
        }
        try {
            for (int i = 0; i < volumeThreads.size(); ++i) {
                ((Thread)volumeThreads.get(i)).join();
            }
        }
        catch (InterruptedException ex) {
            LOG.error("Volume Threads Interrupted exception", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        LOG.info("Build ContainerSet costs {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
    }

    private void startContainerScrub() {
        ContainerScrubberConfiguration c = (ContainerScrubberConfiguration)this.config.getObject(ContainerScrubberConfiguration.class);
        boolean enabled = c.isEnabled();
        if (!enabled) {
            LOG.info("Background container scanner has been disabled.");
        } else {
            if (this.metadataScanner == null) {
                this.metadataScanner = new ContainerMetadataScanner(c, this.controller);
            }
            this.metadataScanner.start();
            this.dataScanners = new ArrayList<ContainerDataScanner>();
            for (HddsVolume v : this.volumeSet.getVolumesList()) {
                ContainerDataScanner s = new ContainerDataScanner(c, this.controller, v);
                s.start();
                this.dataScanners.add(s);
            }
        }
    }

    private void stopContainerScrub() {
        if (this.metadataScanner == null) {
            return;
        }
        this.metadataScanner.shutdown();
        this.metadataScanner = null;
        for (ContainerDataScanner s : this.dataScanners) {
            s.shutdown();
        }
    }

    public void start(String scmId) throws IOException {
        LOG.info("Attempting to start container services.");
        this.startContainerScrub();
        this.replicationServer.start();
        this.datanodeDetails.setPort(DatanodeDetails.Port.Name.REPLICATION, this.replicationServer.getPort());
        this.writeChannel.start();
        this.readChannel.start();
        this.hddsDispatcher.init();
        this.hddsDispatcher.setScmId(scmId);
        this.blockDeletingService.start();
    }

    public void stop() {
        LOG.info("Attempting to stop container services.");
        this.stopContainerScrub();
        this.replicationServer.stop();
        this.writeChannel.stop();
        this.readChannel.stop();
        this.handlers.values().forEach(Handler::stop);
        this.hddsDispatcher.shutdown();
        this.volumeSet.shutdown();
        this.blockDeletingService.shutdown();
        ContainerMetrics.remove();
    }

    public void handleVolumeFailures() {
        if (this.containerSet != null) {
            this.containerSet.handleVolumeFailures();
        }
    }

    @VisibleForTesting
    public ContainerSet getContainerSet() {
        return this.containerSet;
    }

    public StorageContainerDatanodeProtocolProtos.PipelineReportsProto getPipelineReport() {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder pipelineReportsProto = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        pipelineReportsProto.addAllPipelineReport(this.writeChannel.getPipelineReport());
        return pipelineReportsProto.build();
    }

    public XceiverServerSpi getWriteChannel() {
        return this.writeChannel;
    }

    public XceiverServerSpi getReadChannel() {
        return this.readChannel;
    }

    public ContainerController getController() {
        return this.controller;
    }

    public StorageContainerDatanodeProtocolProtos.NodeReportProto getNodeReport() throws IOException {
        StorageLocationReport[] reports = this.volumeSet.getStorageReport();
        StorageContainerDatanodeProtocolProtos.NodeReportProto.Builder nrb = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder();
        for (int i = 0; i < reports.length; ++i) {
            nrb.addStorageReport(reports[i].getProtoBufMessage());
        }
        List<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> metadataReport = this.writeChannel.getStorageReport();
        if (metadataReport != null) {
            nrb.addAllMetadataStorageReport(metadataReport);
        }
        return nrb.build();
    }

    @VisibleForTesting
    public ContainerDispatcher getDispatcher() {
        return this.hddsDispatcher;
    }

    public MutableVolumeSet getVolumeSet() {
        return this.volumeSet;
    }
}

