/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.impl.FilePerBlockStrategy;
import org.apache.hadoop.ozone.container.keyvalue.impl.FilePerChunkStrategy;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkManagerDispatcher
implements ChunkManager {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkManagerDispatcher.class);
    private final Map<ChunkLayOutVersion, ChunkManager> handlers = new EnumMap<ChunkLayOutVersion, ChunkManager>(ChunkLayOutVersion.class);

    ChunkManagerDispatcher(boolean sync, BlockManager manager) {
        this.handlers.put(ChunkLayOutVersion.FILE_PER_CHUNK, new FilePerChunkStrategy(sync, manager));
        this.handlers.put(ChunkLayOutVersion.FILE_PER_BLOCK, new FilePerBlockStrategy(sync, manager));
    }

    @Override
    public void writeChunk(Container container, BlockID blockID, ChunkInfo info, ChunkBuffer data, DispatcherContext dispatcherContext) throws StorageContainerException {
        this.selectHandler(container).writeChunk(container, blockID, info, data, dispatcherContext);
    }

    @Override
    public void finishWriteChunks(KeyValueContainer kvContainer, BlockData blockData) throws IOException {
        this.selectHandler(kvContainer).finishWriteChunks(kvContainer, blockData);
    }

    @Override
    public ChunkBuffer readChunk(Container container, BlockID blockID, ChunkInfo info, DispatcherContext dispatcherContext) throws StorageContainerException {
        ChunkBuffer data = this.selectHandler(container).readChunk(container, blockID, info, dispatcherContext);
        Preconditions.checkState((data != null ? 1 : 0) != 0);
        ((ContainerData)container.getContainerData()).updateReadStats(data.remaining());
        return data;
    }

    @Override
    public void deleteChunk(Container container, BlockID blockID, ChunkInfo info) throws StorageContainerException {
        Preconditions.checkNotNull((Object)blockID, (Object)"Block ID cannot be null.");
        this.selectHandler(container).deleteChunk(container, blockID, info);
        ((ContainerData)container.getContainerData()).decrBytesUsed(info.getLen());
    }

    @Override
    public void deleteChunks(Container container, BlockData blockData) throws StorageContainerException {
        Preconditions.checkNotNull((Object)blockData, (Object)"Block data cannot be null.");
        this.selectHandler(container).deleteChunks(container, blockData);
        ((ContainerData)container.getContainerData()).decrBytesUsed(blockData.getChunks().stream().mapToLong(ContainerProtos.ChunkInfo::getLen).sum());
    }

    @Override
    public void shutdown() {
        this.handlers.values().forEach(ChunkManager::shutdown);
    }

    @Nonnull
    private ChunkManager selectHandler(Container container) throws StorageContainerException {
        ChunkLayOutVersion layout = ((ContainerData)container.getContainerData()).getLayOutVersion();
        return this.selectVersionHandler(layout);
    }

    @Nonnull
    private ChunkManager selectVersionHandler(ChunkLayOutVersion version) throws StorageContainerException {
        ChunkManager versionHandler = this.handlers.get((Object)version);
        if (versionHandler == null) {
            return ChunkManagerDispatcher.throwUnknownLayoutVersion(version);
        }
        return versionHandler;
    }

    private static ChunkManager throwUnknownLayoutVersion(ChunkLayOutVersion version) throws StorageContainerException {
        String message = "Unsupported storage container layout: " + (Object)((Object)version);
        LOG.warn(message);
        throw new StorageContainerException(message, ContainerProtos.Result.UNSUPPORTED_REQUEST);
    }
}

