/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.DataNodeLayoutVersion;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

public final class HddsVolumeUtil {
    private static final String VERSION_FILE = "VERSION";
    private static final String STORAGE_ID_PREFIX = "DS-";

    private HddsVolumeUtil() {
    }

    public static File getVersionFile(File rootDir) {
        return new File(rootDir, VERSION_FILE);
    }

    public static String generateUuid() {
        return STORAGE_ID_PREFIX + UUID.randomUUID();
    }

    public static String getHddsRoot(String volumeRoot) {
        if (volumeRoot.endsWith("hdds")) {
            return volumeRoot;
        }
        File hddsRoot = new File(volumeRoot, "hdds");
        return hddsRoot.getPath();
    }

    @VisibleForTesting
    public static String getStorageID(Properties props, File versionFile) throws InconsistentStorageStateException {
        return HddsVolumeUtil.getProperty(props, "storageID", versionFile);
    }

    @VisibleForTesting
    public static String getClusterID(Properties props, File versionFile, String clusterID) throws InconsistentStorageStateException {
        String cid = HddsVolumeUtil.getProperty(props, "clusterID", versionFile);
        if (clusterID == null) {
            return cid;
        }
        if (!clusterID.equals(cid)) {
            throw new InconsistentStorageStateException("Mismatched ClusterIDs. Version File : " + versionFile + " has clusterID: " + cid + " and Datanode has clusterID: " + clusterID);
        }
        return cid;
    }

    @VisibleForTesting
    public static String getDatanodeUUID(Properties props, File versionFile, String datanodeUuid) throws InconsistentStorageStateException {
        String datanodeID = HddsVolumeUtil.getProperty(props, "datanodeUuid", versionFile);
        if (datanodeUuid != null && !datanodeUuid.equals(datanodeID)) {
            throw new InconsistentStorageStateException("Mismatched DatanodeUUIDs. Version File : " + versionFile + " has datanodeUuid: " + datanodeID + " and Datanode has datanodeUuid: " + datanodeUuid);
        }
        return datanodeID;
    }

    @VisibleForTesting
    public static long getCreationTime(Properties props, File versionFile) throws InconsistentStorageStateException {
        long currentTime;
        String cTimeStr = HddsVolumeUtil.getProperty(props, "ctime", versionFile);
        long cTime = Long.parseLong(cTimeStr);
        if (cTime > (currentTime = Time.now()) || cTime < 0L) {
            throw new InconsistentStorageStateException("Invalid Creation time in Version File : " + versionFile + " - " + cTime + ". Current system time is " + currentTime);
        }
        return cTime;
    }

    @VisibleForTesting
    public static int getLayOutVersion(Properties props, File versionFile) throws InconsistentStorageStateException {
        String lvStr = HddsVolumeUtil.getProperty(props, "layOutVersion", versionFile);
        int lv = Integer.parseInt(lvStr);
        if (DataNodeLayoutVersion.getLatestVersion().getVersion() != lv) {
            throw new InconsistentStorageStateException("Invalid layOutVersion. Version file has layOutVersion as " + lv + " and latest Datanode layOutVersion is " + DataNodeLayoutVersion.getLatestVersion().getVersion());
        }
        return lv;
    }

    public static String getProperty(Properties props, String propName, File versionFile) throws InconsistentStorageStateException {
        String value = props.getProperty(propName);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new InconsistentStorageStateException("Invalid " + propName + ". Version File : " + versionFile + " has null or empty " + propName);
        }
        return value;
    }

    public static boolean checkVolume(HddsVolume hddsVolume, String scmId, String clusterId, Logger logger) {
        File hddsRoot = hddsVolume.getHddsRootDir();
        String volumeRoot = hddsRoot.getPath();
        File scmDir = new File(hddsRoot, scmId);
        try {
            hddsVolume.format(clusterId);
        }
        catch (IOException ex) {
            logger.error("Error during formatting volume {}.", (Object)volumeRoot, (Object)ex);
            return false;
        }
        File[] hddsFiles = hddsRoot.listFiles();
        if (hddsFiles == null) {
            return false;
        }
        if (hddsFiles.length == 1) {
            if (!scmDir.mkdir()) {
                logger.error("Unable to create scmDir {}", (Object)scmDir);
                return false;
            }
            return true;
        }
        if (hddsFiles.length == 2) {
            if (scmDir.exists()) {
                return true;
            }
            logger.error("Volume {} is in Inconsistent state, expected scm directory {} does not exist", (Object)volumeRoot, (Object)scmDir.getAbsolutePath());
            return false;
        }
        logger.error("The hdds root dir {} should always have 2 files. One is Version file and other is SCM directory. Please remove any other extra files from the directory so that DataNode startup can proceed.", (Object)hddsRoot.getAbsolutePath());
        return false;
    }
}

