/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.protocol.commands.SetNodeOperationalStateCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetNodeOperationalStateCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SetNodeOperationalStateCommandHandler.class);
    private final ConfigurationSource conf;
    private final AtomicInteger invocationCount = new AtomicInteger(0);
    private final AtomicLong totalTime = new AtomicLong(0L);

    public SetNodeOperationalStateCommandHandler(ConfigurationSource conf) {
        this.conf = conf;
    }

    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        long startTime = Time.monotonicNow();
        this.invocationCount.incrementAndGet();
        StorageContainerDatanodeProtocolProtos.SetNodeOperationalStateCommandProto setNodeCmdProto = null;
        if (command.getType() != StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand) {
            LOG.warn("Skipping handling command, expected command type {} but found {}", (Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand, (Object)command.getType());
            return;
        }
        SetNodeOperationalStateCommand setNodeCmd = (SetNodeOperationalStateCommand)command;
        setNodeCmdProto = setNodeCmd.getProto();
        DatanodeDetails dni = context.getParent().getDatanodeDetails();
        dni.setPersistedOpState(setNodeCmdProto.getNodeOperationalState());
        dni.setPersistedOpStateExpiryEpochSec(setNodeCmd.getStateExpiryEpochSeconds());
        try {
            this.persistDatanodeDetails(dni);
        }
        catch (IOException ioe) {
            LOG.error("Failed to persist the datanode state", (Throwable)ioe);
        }
        this.totalTime.addAndGet(Time.monotonicNow() - startTime);
    }

    private void persistDatanodeDetails(DatanodeDetails dnDetails) throws IOException {
        String idFilePath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)this.conf);
        if (idFilePath == null || idFilePath.isEmpty()) {
            LOG.error("A valid path is needed for config setting {}", (Object)"ozone.scm.datanode.id.dir");
            throw new IllegalArgumentException("ozone.scm.datanode.id.dir must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        ContainerUtils.writeDatanodeDetailsTo(dnDetails, idFile);
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount.intValue();
    }

    @Override
    public long getAverageRunTime() {
        int invocations = this.invocationCount.get();
        return invocations == 0 ? 0L : this.totalTime.get() / (long)invocations;
    }
}

