/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosePipelineCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClosePipelineCommandHandler.class);
    private AtomicLong invocationCount = new AtomicLong(0L);
    private long totalTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        this.invocationCount.incrementAndGet();
        long startTime = Time.monotonicNow();
        DatanodeDetails dn = context.getParent().getDatanodeDetails();
        ClosePipelineCommand closePipelineCommand = (ClosePipelineCommand)command;
        PipelineID pipelineID = closePipelineCommand.getPipelineID();
        try {
            XceiverServerSpi server = ozoneContainer.getWriteChannel();
            server.removeGroup(pipelineID.getProtobuf());
            LOG.info("Close Pipeline {} command on datanode {}.", (Object)pipelineID, (Object)dn.getUuidString());
        }
        catch (IOException e) {
            LOG.error("Can't close pipeline {}", (Object)pipelineID, (Object)e);
        }
        finally {
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closePipelineCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount.get() > 0L) {
            return this.totalTime / this.invocationCount.get();
        }
        return 0L;
    }
}

