/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.InitDatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.RunningDatanodeState;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlockCommandStatus;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateContext {
    @VisibleForTesting
    static final String CONTAINER_REPORTS_PROTO_NAME = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String NODE_REPORT_PROTO_NAME = StorageContainerDatanodeProtocolProtos.NodeReportProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String PIPELINE_REPORTS_PROTO_NAME = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String COMMAND_STATUS_REPORTS_PROTO_NAME = StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String INCREMENTAL_CONTAINER_REPORT_PROTO_NAME = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.getDescriptor().getFullName();
    private static final Set<String> ACCEPTED_INCREMENTAL_REPORT_TYPE_SET = Sets.newHashSet((Object[])new String[]{COMMAND_STATUS_REPORTS_PROTO_NAME, INCREMENTAL_CONTAINER_REPORT_PROTO_NAME});
    static final Logger LOG = LoggerFactory.getLogger(StateContext.class);
    private final Queue<SCMCommand> commandQueue;
    private final Map<Long, CommandStatus> cmdStatusMap;
    private final Lock lock;
    private final DatanodeStateMachine parent;
    private final AtomicLong stateExecutionCount;
    private final ConfigurationSource conf;
    private final Set<InetSocketAddress> endpoints;
    private final AtomicReference<GeneratedMessage> containerReports;
    private final AtomicReference<GeneratedMessage> nodeReport;
    private final AtomicReference<GeneratedMessage> pipelineReports;
    private final Map<InetSocketAddress, List<GeneratedMessage>> incrementalReportsQueue;
    private final Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> containerActions;
    private final Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>> pipelineActions;
    private DatanodeStateMachine.DatanodeStates state;
    private boolean shutdownOnError = false;
    private boolean shutdownGracefully = false;
    private final AtomicLong threadPoolNotAvailableCount;
    private AtomicLong heartbeatFrequency = new AtomicLong(2000L);

    public StateContext(ConfigurationSource conf, DatanodeStateMachine.DatanodeStates state, DatanodeStateMachine parent) {
        this.conf = conf;
        this.state = state;
        this.parent = parent;
        this.commandQueue = new LinkedList<SCMCommand>();
        this.cmdStatusMap = new ConcurrentHashMap<Long, CommandStatus>();
        this.incrementalReportsQueue = new HashMap<InetSocketAddress, List<GeneratedMessage>>();
        this.containerReports = new AtomicReference();
        this.nodeReport = new AtomicReference();
        this.pipelineReports = new AtomicReference();
        this.endpoints = new HashSet<InetSocketAddress>();
        this.containerActions = new HashMap<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>>();
        this.pipelineActions = new HashMap<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>>();
        this.lock = new ReentrantLock();
        this.stateExecutionCount = new AtomicLong(0L);
        this.threadPoolNotAvailableCount = new AtomicLong(0L);
    }

    public DatanodeStateMachine getParent() {
        return this.parent;
    }

    boolean isEntering() {
        return this.stateExecutionCount.get() == 0L;
    }

    boolean isExiting(DatanodeStateMachine.DatanodeStates newState) {
        boolean isExiting;
        boolean bl = isExiting = this.state != newState && this.stateExecutionCount.get() > 0L;
        if (isExiting) {
            this.stateExecutionCount.set(0L);
        }
        return isExiting;
    }

    public DatanodeStateMachine.DatanodeStates getState() {
        return this.state;
    }

    public void setState(DatanodeStateMachine.DatanodeStates state) {
        if (this.state != state) {
            if (this.state.isTransitionAllowedTo(state)) {
                this.state = state;
            } else {
                LOG.warn("Ignore disallowed transition from {} to {}", (Object)this.state, (Object)state);
            }
        }
    }

    private void setShutdownOnError() {
        this.shutdownOnError = true;
    }

    void setShutdownGracefully() {
        this.shutdownGracefully = true;
    }

    public boolean getShutdownOnError() {
        return this.shutdownOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReport(GeneratedMessage report) {
        if (report == null) {
            return;
        }
        Descriptors.Descriptor descriptor = report.getDescriptorForType();
        Preconditions.checkState((descriptor != null ? 1 : 0) != 0);
        String reportType = descriptor.getFullName();
        Preconditions.checkState((reportType != null ? 1 : 0) != 0);
        for (InetSocketAddress endpoint : this.endpoints) {
            if (reportType.equals(CONTAINER_REPORTS_PROTO_NAME)) {
                this.containerReports.set(report);
                continue;
            }
            if (reportType.equals(NODE_REPORT_PROTO_NAME)) {
                this.nodeReport.set(report);
                continue;
            }
            if (reportType.equals(PIPELINE_REPORTS_PROTO_NAME)) {
                this.pipelineReports.set(report);
                continue;
            }
            if (ACCEPTED_INCREMENTAL_REPORT_TYPE_SET.contains(reportType)) {
                Map<InetSocketAddress, List<GeneratedMessage>> map = this.incrementalReportsQueue;
                synchronized (map) {
                    this.incrementalReportsQueue.get(endpoint).add(report);
                    continue;
                }
            }
            throw new IllegalArgumentException("Unidentified report message type: " + reportType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBackReports(List<GeneratedMessage> reportsToPutBack, InetSocketAddress endpoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("endpoint: {}, size of reportsToPutBack: {}", (Object)endpoint, (Object)reportsToPutBack.size());
        }
        for (GeneratedMessage report : reportsToPutBack) {
            Descriptors.Descriptor descriptor = report.getDescriptorForType();
            Preconditions.checkState((descriptor != null ? 1 : 0) != 0);
            String reportType = descriptor.getFullName();
            Preconditions.checkState((reportType != null ? 1 : 0) != 0);
            if (ACCEPTED_INCREMENTAL_REPORT_TYPE_SET.contains(reportType)) continue;
            throw new IllegalArgumentException("Unaccepted report message type: " + reportType);
        }
        Map<InetSocketAddress, List<GeneratedMessage>> map = this.incrementalReportsQueue;
        synchronized (map) {
            if (this.incrementalReportsQueue.containsKey(endpoint)) {
                this.incrementalReportsQueue.get(endpoint).addAll(0, reportsToPutBack);
            }
        }
    }

    public List<GeneratedMessage> getAllAvailableReports(InetSocketAddress endpoint) {
        return this.getReports(endpoint, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GeneratedMessage> getIncrementalReports(InetSocketAddress endpoint, int maxLimit) {
        LinkedList<GeneratedMessage> reportsToReturn = new LinkedList<GeneratedMessage>();
        Map<InetSocketAddress, List<GeneratedMessage>> map = this.incrementalReportsQueue;
        synchronized (map) {
            List<GeneratedMessage> reportsForEndpoint = this.incrementalReportsQueue.get(endpoint);
            if (reportsForEndpoint != null) {
                List<GeneratedMessage> tempList = reportsForEndpoint.subList(0, Math.min(reportsForEndpoint.size(), maxLimit));
                reportsToReturn.addAll(tempList);
                tempList.clear();
            }
        }
        return reportsToReturn;
    }

    List<GeneratedMessage> getNonIncrementalReports() {
        LinkedList<GeneratedMessage> nonIncrementalReports = new LinkedList<GeneratedMessage>();
        GeneratedMessage report = this.containerReports.get();
        if (report != null) {
            nonIncrementalReports.add(report);
        }
        if ((report = this.nodeReport.get()) != null) {
            nonIncrementalReports.add(report);
        }
        if ((report = this.pipelineReports.get()) != null) {
            nonIncrementalReports.add(report);
        }
        return nonIncrementalReports;
    }

    public List<GeneratedMessage> getReports(InetSocketAddress endpoint, int maxLimit) {
        if (maxLimit < 0) {
            throw new IllegalArgumentException("Illegal maxLimit value: " + maxLimit);
        }
        List<GeneratedMessage> reports = this.getNonIncrementalReports();
        if (maxLimit <= reports.size()) {
            return reports.subList(0, maxLimit);
        }
        reports.addAll(this.getIncrementalReports(endpoint, maxLimit - reports.size()));
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerAction(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            for (InetSocketAddress endpoint : this.endpoints) {
                this.containerActions.get(endpoint).add(containerAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerActionIfAbsent(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            for (InetSocketAddress endpoint : this.endpoints) {
                if (this.containerActions.get(endpoint).contains(containerAction)) continue;
                this.containerActions.get(endpoint).add(containerAction);
            }
        }
    }

    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getAllPendingContainerActions(InetSocketAddress endpoint) {
        return this.getPendingContainerAction(endpoint, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getPendingContainerAction(InetSocketAddress endpoint, int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction> containerActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction>();
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            if (!this.containerActions.isEmpty() && CollectionUtils.isNotEmpty((Collection)this.containerActions.get(endpoint))) {
                Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.containerActions.get(endpoint);
                int size = actions.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    StorageContainerDatanodeProtocolProtos.ContainerAction action = actions.poll();
                    Preconditions.checkNotNull((Object)action);
                    containerActionList.add(action);
                }
            }
            return containerActionList;
        }
    }

    boolean isSameClosePipelineAction(StorageContainerDatanodeProtocolProtos.PipelineAction a1, StorageContainerDatanodeProtocolProtos.PipelineAction a2) {
        return a1.getAction() == a2.getAction() && a1.hasClosePipeline() && a2.hasClosePipeline() && a1.getClosePipeline().getPipelineID().equals((Object)a2.getClosePipeline().getPipelineID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPipelineActionIfAbsent(StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction) {
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>> map = this.pipelineActions;
        synchronized (map) {
            for (InetSocketAddress endpoint : this.endpoints) {
                Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> actionsForEndpoint = this.pipelineActions.get(endpoint);
                if (!actionsForEndpoint.stream().noneMatch(action -> this.isSameClosePipelineAction((StorageContainerDatanodeProtocolProtos.PipelineAction)action, pipelineAction))) continue;
                actionsForEndpoint.add(pipelineAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.PipelineAction> getPendingPipelineAction(InetSocketAddress endpoint, int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction> pipelineActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction>();
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>> map = this.pipelineActions;
        synchronized (map) {
            if (!this.pipelineActions.isEmpty() && CollectionUtils.isNotEmpty((Collection)this.pipelineActions.get(endpoint))) {
                Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> actionsForEndpoint = this.pipelineActions.get(endpoint);
                int size = actionsForEndpoint.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    pipelineActionList.add(actionsForEndpoint.poll());
                }
            }
            return pipelineActionList;
        }
    }

    public DatanodeState<DatanodeStateMachine.DatanodeStates> getTask() {
        switch (this.state) {
            case INIT: {
                return new InitDatanodeState(this.conf, this.parent.getConnectionManager(), this);
            }
            case RUNNING: {
                return new RunningDatanodeState(this.conf, this.parent.getConnectionManager(), this);
            }
            case SHUTDOWN: {
                return null;
            }
        }
        throw new IllegalArgumentException("Not Implemented yet.");
    }

    @VisibleForTesting
    public boolean isThreadPoolAvailable(ExecutorService executor) {
        if (!(executor instanceof ThreadPoolExecutor)) {
            return true;
        }
        ThreadPoolExecutor ex = (ThreadPoolExecutor)executor;
        return ex.getQueue().size() == 0;
    }

    public void execute(ExecutorService service, long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.stateExecutionCount.incrementAndGet();
        DatanodeState<DatanodeStateMachine.DatanodeStates> task = this.getTask();
        if (task != null) {
            if (this.isEntering()) {
                task.onEnter();
            }
            if (!this.isThreadPoolAvailable(service)) {
                long count = this.threadPoolNotAvailableCount.getAndIncrement();
                if (count % (long)HddsServerUtil.getLogWarnInterval((ConfigurationSource)this.conf) == 0L) {
                    LOG.warn("No available thread in pool for past {} seconds.", (Object)(unit.toSeconds(time) * (count + 1L)));
                }
                return;
            }
            this.threadPoolNotAvailableCount.set(0L);
            task.execute(service);
            DatanodeStateMachine.DatanodeStates newState = task.await(time, unit);
            if (this.state != newState) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Task {} executed, state transited from {} to {}", new Object[]{task.getClass().getSimpleName(), this.state, newState});
                }
                if (this.isExiting(newState)) {
                    task.onExit();
                }
                this.setState(newState);
            }
            if (!this.shutdownGracefully && this.state == DatanodeStateMachine.DatanodeStates.SHUTDOWN) {
                LOG.error("Critical error occurred in StateMachine, setting shutDownMachine");
                this.setShutdownOnError();
            }
        }
    }

    public SCMCommand getNextCommand() {
        this.lock.lock();
        try {
            SCMCommand sCMCommand = this.commandQueue.poll();
            return sCMCommand;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCommand(SCMCommand command) {
        this.lock.lock();
        try {
            this.commandQueue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        this.addCmdStatus(command);
    }

    public long getExecutionCount() {
        return this.stateExecutionCount.get();
    }

    public CommandStatus getCmdStatus(Long key) {
        return this.cmdStatusMap.get(key);
    }

    public void addCmdStatus(Long key, CommandStatus status) {
        this.cmdStatusMap.put(key, status);
    }

    public void addCmdStatus(SCMCommand cmd) {
        if (cmd.getType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) {
            this.addCmdStatus(cmd.getId(), DeleteBlockCommandStatus.DeleteBlockCommandStatusBuilder.newBuilder().setCmdId(cmd.getId()).setStatus(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING).setType(cmd.getType()).build());
        }
    }

    public Map<Long, CommandStatus> getCommandStatusMap() {
        return this.cmdStatusMap;
    }

    public boolean updateCommandStatus(Long cmdId, Consumer<CommandStatus> cmdStatusUpdater) {
        if (this.cmdStatusMap.containsKey(cmdId)) {
            cmdStatusUpdater.accept(this.cmdStatusMap.get(cmdId));
            return true;
        }
        return false;
    }

    public void configureHeartbeatFrequency() {
        this.heartbeatFrequency.set(HddsServerUtil.getScmHeartbeatInterval((ConfigurationSource)this.conf));
    }

    public long getHeartbeatFrequency() {
        return this.heartbeatFrequency.get();
    }

    public void addEndpoint(InetSocketAddress endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
            this.containerActions.put(endpoint, new LinkedList());
            this.pipelineActions.put(endpoint, new LinkedList());
            this.incrementalReportsQueue.put(endpoint, new LinkedList());
        }
    }

    @VisibleForTesting
    public GeneratedMessage getContainerReports() {
        return this.containerReports.get();
    }

    @VisibleForTesting
    public GeneratedMessage getNodeReport() {
        return this.nodeReport.get();
    }

    @VisibleForTesting
    public GeneratedMessage getPipelineReports() {
        return this.pipelineReports.get();
    }
}

