/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.yaml.snakeyaml.Yaml;

public abstract class ContainerData {
    private final ContainerProtos.ContainerType containerType;
    private final long containerID;
    private final int layOutVersion;
    private final Map<String, String> metadata;
    private String chunksPath;
    private ContainerProtos.ContainerDataProto.State state;
    private final long maxSize;
    private boolean committedSpace;
    private String originPipelineId;
    private String originNodeId;
    private final AtomicLong readBytes;
    private final AtomicLong writeBytes;
    private final AtomicLong readCount;
    private final AtomicLong writeCount;
    private final AtomicLong bytesUsed;
    private final AtomicLong keyCount;
    private HddsVolume volume;
    private String checksum;
    private Long dataScanTimestamp;
    private transient Optional<Instant> lastDataScanTime = Optional.empty();
    public static final Charset CHARSET_ENCODING = StandardCharsets.UTF_8;
    private static final String DUMMY_CHECKSUM = new String(new byte[64], CHARSET_ENCODING);
    protected static final List<String> YAML_FIELDS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"containerType", "containerID", "layOutVersion", "state", "metadata", "maxSize", "checksum", "dataScanTimestamp", "originPipelineId", "originNodeId"}));

    protected ContainerData(ContainerProtos.ContainerType type, long containerId, ChunkLayOutVersion layOutVersion, long size, String originPipelineId, String originNodeId) {
        Preconditions.checkNotNull((Object)type);
        this.containerType = type;
        this.containerID = containerId;
        this.layOutVersion = layOutVersion.getVersion();
        this.metadata = new TreeMap<String, String>();
        this.state = ContainerProtos.ContainerDataProto.State.OPEN;
        this.readCount = new AtomicLong(0L);
        this.readBytes = new AtomicLong(0L);
        this.writeCount = new AtomicLong(0L);
        this.writeBytes = new AtomicLong(0L);
        this.bytesUsed = new AtomicLong(0L);
        this.keyCount = new AtomicLong(0L);
        this.maxSize = size;
        this.originPipelineId = originPipelineId;
        this.originNodeId = originNodeId;
        this.setChecksumTo0ByteArray();
    }

    protected ContainerData(ContainerData source) {
        this(source.getContainerType(), source.getContainerID(), source.getLayOutVersion(), source.getMaxSize(), source.getOriginPipelineId(), source.getOriginNodeId());
    }

    public long getContainerID() {
        return this.containerID;
    }

    public abstract String getContainerPath();

    public ContainerProtos.ContainerType getContainerType() {
        return this.containerType;
    }

    public synchronized ContainerProtos.ContainerDataProto.State getState() {
        return this.state;
    }

    public synchronized void setState(ContainerProtos.ContainerDataProto.State state) {
        ContainerProtos.ContainerDataProto.State oldState = this.state;
        this.state = state;
        if (oldState == ContainerProtos.ContainerDataProto.State.OPEN && state != oldState) {
            this.releaseCommitSpace();
        }
        if (state == ContainerProtos.ContainerDataProto.State.OPEN && state != oldState) {
            Preconditions.checkState((this.getMaxSize() > 0L ? 1 : 0) != 0);
            this.commitSpace();
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public ChunkLayOutVersion getLayOutVersion() {
        return ChunkLayOutVersion.getChunkLayOutVersion(this.layOutVersion);
    }

    public String getChunksPath() {
        return this.chunksPath;
    }

    public void setChunksPath(String chunkPath) {
        this.chunksPath = chunkPath;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void setMetadata(Map<String, String> metadataMap) {
        this.metadata.clear();
        this.metadata.putAll(metadataMap);
    }

    public synchronized boolean isOpen() {
        return ContainerProtos.ContainerDataProto.State.OPEN == this.state;
    }

    public synchronized boolean isValid() {
        return ContainerProtos.ContainerDataProto.State.INVALID != this.state;
    }

    public synchronized boolean isClosed() {
        return ContainerProtos.ContainerDataProto.State.CLOSED == this.state;
    }

    public synchronized boolean isQuasiClosed() {
        return ContainerProtos.ContainerDataProto.State.QUASI_CLOSED == this.state;
    }

    public synchronized boolean isUnhealthy() {
        return ContainerProtos.ContainerDataProto.State.UNHEALTHY == this.state;
    }

    public synchronized void quasiCloseContainer() {
        this.setState(ContainerProtos.ContainerDataProto.State.QUASI_CLOSED);
    }

    public synchronized void closeContainer() {
        this.setState(ContainerProtos.ContainerDataProto.State.CLOSED);
    }

    private void releaseCommitSpace() {
        long unused = this.getMaxSize() - this.getBytesUsed();
        if (unused > 0L && this.committedSpace) {
            this.getVolume().incCommittedBytes(0L - unused);
        }
        this.committedSpace = false;
    }

    public void commitSpace() {
        long unused = this.getMaxSize() - this.getBytesUsed();
        ContainerProtos.ContainerDataProto.State myState = this.getState();
        Preconditions.checkState((!this.committedSpace ? 1 : 0) != 0);
        if (myState != ContainerProtos.ContainerDataProto.State.OPEN) {
            return;
        }
        HddsVolume cVol = this.getVolume();
        if (unused > 0L && cVol != null) {
            cVol.incCommittedBytes(unused);
            this.committedSpace = true;
        }
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public void incrReadBytes(long bytes) {
        this.readBytes.addAndGet(bytes);
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public void incrReadCount() {
        this.readCount.incrementAndGet();
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    public void incrWriteBytes(long bytes) {
        long unused = this.getMaxSize() - this.getBytesUsed();
        this.writeBytes.addAndGet(bytes);
        if (this.committedSpace && unused > 0L) {
            long decrement = Math.min(bytes, unused);
            this.getVolume().incCommittedBytes(0L - decrement);
        }
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public void incrWriteCount() {
        this.writeCount.incrementAndGet();
    }

    public void setBytesUsed(long used) {
        this.bytesUsed.set(used);
    }

    public long getBytesUsed() {
        return this.bytesUsed.get();
    }

    public long incrBytesUsed(long used) {
        return this.bytesUsed.addAndGet(used);
    }

    public long decrBytesUsed(long reclaimed) {
        return this.bytesUsed.addAndGet(-1L * reclaimed);
    }

    public void setVolume(HddsVolume hddsVolume) {
        this.volume = hddsVolume;
    }

    public HddsVolume getVolume() {
        return this.volume;
    }

    public void incrKeyCount() {
        this.keyCount.incrementAndGet();
    }

    public void decrKeyCount() {
        this.keyCount.decrementAndGet();
    }

    public void decrKeyCount(long deletedKeyCount) {
        this.keyCount.addAndGet(-1L * deletedKeyCount);
    }

    public long getKeyCount() {
        return this.keyCount.get();
    }

    public void setKeyCount(long count) {
        this.keyCount.set(count);
    }

    public void setChecksumTo0ByteArray() {
        this.checksum = DUMMY_CHECKSUM;
    }

    public void setChecksum(String checkSum) {
        this.checksum = checkSum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Optional<Instant> lastDataScanTime() {
        return this.lastDataScanTime;
    }

    public void updateDataScanTime(@Nullable Instant time) {
        this.lastDataScanTime = Optional.ofNullable(time);
        this.dataScanTimestamp = time != null ? Long.valueOf(time.toEpochMilli()) : null;
    }

    public void setDataScanTimestamp(Long timestamp) {
        this.dataScanTimestamp = timestamp;
        this.lastDataScanTime = timestamp != null ? Optional.of(Instant.ofEpochMilli(timestamp)) : Optional.empty();
    }

    public Long getDataScanTimestamp() {
        return this.dataScanTimestamp;
    }

    public String getOriginPipelineId() {
        return this.originPipelineId;
    }

    public String getOriginNodeId() {
        return this.originNodeId;
    }

    public void computeAndSetChecksum(Yaml yaml) throws IOException {
        this.setChecksumTo0ByteArray();
        String containerDataYamlStr = yaml.dump((Object)this);
        this.checksum = ContainerUtils.getChecksum(containerDataYamlStr);
    }

    public abstract ContainerProtos.ContainerDataProto getProtoBufMessage();

    public abstract long getBlockCommitSequenceId();

    public void updateReadStats(long length) {
        this.incrReadCount();
        this.incrReadBytes(length);
    }

    public void updateWriteStats(long bytesWritten, boolean overwrite) {
        if (!overwrite) {
            this.incrBytesUsed(bytesWritten);
        }
        this.incrWriteCount();
        this.incrWriteBytes(bytesWritten);
    }
}

