/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.util;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.util.ProtoUtils;

public final class ServerStringUtils {
    private ServerStringUtils() {
    }

    public static String toAppendEntriesRequestString(RaftProtos.AppendEntriesRequestProto request) {
        if (request == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()) + "-t" + request.getLeaderTerm() + ",previous=" + TermIndex.valueOf((RaftProtos.TermIndexProto)request.getPreviousLog()) + ",leaderCommit=" + request.getLeaderCommit() + ",initializing? " + request.getInitializing() + ",entries: " + LogProtoUtils.toLogEntriesShortString(request.getEntriesList());
    }

    public static String toAppendEntriesReplyString(RaftProtos.AppendEntriesReplyProto reply) {
        if (reply == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)reply.getServerReply()) + "-t" + reply.getTerm() + "," + reply.getResult() + ",nextIndex=" + reply.getNextIndex() + ",followerCommit=" + reply.getFollowerCommit();
    }

    public static String toInstallSnapshotRequestString(RaftProtos.InstallSnapshotRequestProto request) {
        String s;
        if (request == null) {
            return null;
        }
        switch (request.getInstallSnapshotRequestBodyCase()) {
            case SNAPSHOTCHUNK: {
                RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto chunk = request.getSnapshotChunk();
                s = "chunk:" + chunk.getRequestId() + "," + chunk.getRequestIndex();
                break;
            }
            case NOTIFICATION: {
                RaftProtos.InstallSnapshotRequestProto.NotificationProto notification = request.getNotification();
                s = "notify:" + TermIndex.valueOf((RaftProtos.TermIndexProto)notification.getFirstAvailableTermIndex());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected body case in " + request);
            }
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()) + "-t" + request.getLeaderTerm() + "," + s;
    }

    public static String toInstallSnapshotReplyString(RaftProtos.InstallSnapshotReplyProto reply) {
        String s;
        if (reply == null) {
            return null;
        }
        switch (reply.getInstallSnapshotReplyBodyCase()) {
            case REQUESTINDEX: {
                s = ",requestIndex=" + reply.getRequestIndex();
                break;
            }
            case SNAPSHOTINDEX: {
                s = ",snapshotIndex=" + reply.getSnapshotIndex();
                break;
            }
            default: {
                s = "";
            }
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)reply.getServerReply()) + "-t" + reply.getTerm() + "," + reply.getResult() + s;
    }

    public static String toRequestVoteReplyString(RaftProtos.RequestVoteReplyProto proto) {
        if (proto == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)proto.getServerReply()) + "-t" + proto.getTerm();
    }
}

