/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.metrics.RaftServerMetrics;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.Preconditions;

public final class RaftServerMetricsImpl
extends RatisMetrics
implements RaftServerMetrics {
    public static final String RATIS_SERVER_METRICS = "server";
    public static final String RATIS_SERVER_METRICS_DESC = "Metrics for Raft server";
    public static final String FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC = "%s_lastHeartbeatElapsedTime";
    public static final String FOLLOWER_APPEND_ENTRIES_LATENCY = "follower_append_entry_latency";
    public static final String LEADER_METRIC_PEER_COMMIT_INDEX = "%s_peerCommitIndex";
    public static final String RAFT_CLIENT_READ_REQUEST = "clientReadRequest";
    public static final String RAFT_CLIENT_STALE_READ_REQUEST = "clientStaleReadRequest";
    public static final String RAFT_CLIENT_WRITE_REQUEST = "clientWriteRequest";
    public static final String RAFT_CLIENT_WATCH_REQUEST = "clientWatch%sRequest";
    public static final String REQUEST_QUEUE_LIMIT_HIT_COUNTER = "numRequestQueueLimitHits";
    public static final String RESOURCE_LIMIT_HIT_COUNTER = "leaderNumResourceLimitHits";
    public static final String REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER = "numRequestsByteSizeLimitHits";
    public static final String REQUEST_QUEUE_SIZE = "numPendingRequestInQueue";
    public static final String REQUEST_BYTE_SIZE = "numPendingRequestByteSize";
    public static final String RETRY_CACHE_ENTRY_COUNT_METRIC = "retryCacheEntryCount";
    public static final String RETRY_CACHE_HIT_COUNT_METRIC = "retryCacheHitCount";
    public static final String RETRY_CACHE_HIT_RATE_METRIC = "retryCacheHitRate";
    public static final String RETRY_CACHE_MISS_COUNT_METRIC = "retryCacheMissCount";
    public static final String RETRY_CACHE_MISS_RATE_METRIC = "retryCacheMissRate";
    public static final String RATIS_SERVER_FAILED_CLIENT_STALE_READ_COUNT = "numFailedClientStaleReadOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_READ_COUNT = "numFailedClientReadOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_WRITE_COUNT = "numFailedClientWriteOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_WATCH_COUNT = "numFailedClientWatchOnServer";
    public static final String RATIS_SERVER_FAILED_CLIENT_STREAM_COUNT = "numFailedClientStreamOnServer";
    public static final String RATIS_SERVER_INSTALL_SNAPSHOT_COUNT = "numInstallSnapshot";
    private final Map<RaftPeerId, Long> followerLastHeartbeatElapsedTimeMap = new HashMap<RaftPeerId, Long>();
    private final Supplier<Function<RaftPeerId, RaftProtos.CommitInfoProto>> commitInfoCache;
    private static final Map<RaftGroupMemberId, RaftServerMetricsImpl> METRICS = new ConcurrentHashMap<RaftGroupMemberId, RaftServerMetricsImpl>();
    private static final Map<RaftPeerId, String> PEER_COMMIT_INDEX_GAUGE_KEYS = new ConcurrentHashMap<RaftPeerId, String>();

    private static String getPeerCommitIndexGaugeKey(RaftPeerId serverId) {
        return PEER_COMMIT_INDEX_GAUGE_KEYS.computeIfAbsent(serverId, key -> String.format(LEADER_METRIC_PEER_COMMIT_INDEX, key));
    }

    public static RaftServerMetricsImpl computeIfAbsentRaftServerMetrics(RaftGroupMemberId serverId, Supplier<Function<RaftPeerId, RaftProtos.CommitInfoProto>> commitInfoCache, Supplier<RetryCache.Statistics> retryCacheStatistics) {
        return METRICS.computeIfAbsent(serverId, key -> new RaftServerMetricsImpl(serverId, commitInfoCache, retryCacheStatistics));
    }

    public static void removeRaftServerMetrics(RaftGroupMemberId serverId) {
        METRICS.remove(serverId);
    }

    public RaftServerMetricsImpl(RaftGroupMemberId serverId, Supplier<Function<RaftPeerId, RaftProtos.CommitInfoProto>> commitInfoCache, Supplier<RetryCache.Statistics> retryCacheStatistics) {
        this.registry = this.getMetricRegistryForRaftServer(serverId.toString());
        this.commitInfoCache = commitInfoCache;
        this.addPeerCommitIndexGauge(serverId.getPeerId());
        this.addRetryCacheMetric(retryCacheStatistics);
    }

    private RatisMetricRegistry getMetricRegistryForRaftServer(String serverId) {
        return RaftServerMetricsImpl.create((MetricRegistryInfo)new MetricRegistryInfo(serverId, "ratis", RATIS_SERVER_METRICS, RATIS_SERVER_METRICS_DESC));
    }

    private void addRetryCacheMetric(Supplier<RetryCache.Statistics> retryCacheStatistics) {
        this.registry.gauge(RETRY_CACHE_ENTRY_COUNT_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$2((Supplier)retryCacheStatistics));
        this.registry.gauge(RETRY_CACHE_HIT_COUNT_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$4((Supplier)retryCacheStatistics));
        this.registry.gauge(RETRY_CACHE_HIT_RATE_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$6((Supplier)retryCacheStatistics));
        this.registry.gauge(RETRY_CACHE_MISS_COUNT_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$8((Supplier)retryCacheStatistics));
        this.registry.gauge(RETRY_CACHE_MISS_RATE_METRIC, () -> () -> RaftServerMetricsImpl.lambda$null$10((Supplier)retryCacheStatistics));
    }

    public void addFollower(RaftPeerId followerName) {
        String followerHbMetricKey = String.format(FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC, followerName);
        this.followerLastHeartbeatElapsedTimeMap.put(followerName, 0L);
        this.registry.gauge(followerHbMetricKey, () -> () -> this.followerLastHeartbeatElapsedTimeMap.get(followerName));
        this.addPeerCommitIndexGauge(followerName);
    }

    public void addPeerCommitIndexGauge(RaftPeerId peerId) {
        this.registry.gauge(RaftServerMetricsImpl.getPeerCommitIndexGaugeKey(peerId), () -> () -> Optional.ofNullable(this.commitInfoCache.get()).map(cache -> (RaftProtos.CommitInfoProto)cache.apply(peerId)).map(RaftProtos.CommitInfoProto::getCommitIndex).orElse(0L));
    }

    @VisibleForTesting
    public static Gauge getPeerCommitIndexGauge(RaftGroupMemberId serverId, RaftPeerId peerId) {
        RaftServerMetricsImpl serverMetrics = METRICS.get(serverId);
        if (serverMetrics == null) {
            return null;
        }
        String followerCommitIndexKey = RaftServerMetricsImpl.getPeerCommitIndexGaugeKey(peerId);
        SortedMap map = serverMetrics.registry.getGauges((s, metric) -> s.contains(followerCommitIndexKey));
        Preconditions.assertTrue((map.size() <= 1 ? 1 : 0) != 0);
        return (Gauge)map.get(map.firstKey());
    }

    public void recordFollowerHeartbeatElapsedTime(RaftPeerId followerId, long elapsedTimeNs) {
        this.followerLastHeartbeatElapsedTimeMap.put(followerId, elapsedTimeNs);
    }

    public Timer getFollowerAppendEntryTimer(boolean isHeartbeat) {
        return this.registry.timer(FOLLOWER_APPEND_ENTRIES_LATENCY + (isHeartbeat ? "_heartbeat" : ""));
    }

    public Timer getTimer(String timerName) {
        return this.registry.timer(timerName);
    }

    public Counter getCounter(String counterName) {
        return this.registry.counter(counterName);
    }

    public Timer getClientRequestTimer(RaftClientRequest.Type request) {
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
            return this.getTimer(RAFT_CLIENT_READ_REQUEST);
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            return this.getTimer(RAFT_CLIENT_STALE_READ_REQUEST);
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            String watchType = RaftClientRequest.Type.toString((RaftProtos.ReplicationLevel)request.getWatch().getReplication());
            return this.getTimer(String.format(RAFT_CLIENT_WATCH_REQUEST, watchType));
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE)) {
            return this.getTimer(RAFT_CLIENT_WRITE_REQUEST);
        }
        return null;
    }

    public void onRequestQueueLimitHit() {
        this.registry.counter(REQUEST_QUEUE_LIMIT_HIT_COUNTER).inc();
    }

    public void addNumPendingRequestsGauge(Gauge queueSize) {
        this.registry.gauge(REQUEST_QUEUE_SIZE, () -> queueSize);
    }

    public boolean removeNumPendingRequestsGauge() {
        return this.registry.remove(REQUEST_QUEUE_SIZE);
    }

    public void addNumPendingRequestsByteSize(Gauge byteSize) {
        this.registry.gauge(REQUEST_BYTE_SIZE, () -> byteSize);
    }

    public boolean removeNumPendingRequestsByteSize() {
        return this.registry.remove(REQUEST_BYTE_SIZE);
    }

    public void onRequestByteSizeLimitHit() {
        this.registry.counter(REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER).inc();
    }

    public void onResourceLimitHit() {
        this.registry.counter(RESOURCE_LIMIT_HIT_COUNTER).inc();
    }

    void onFailedClientStaleRead() {
        this.registry.counter(RATIS_SERVER_FAILED_CLIENT_STALE_READ_COUNT).inc();
    }

    void onFailedClientRead() {
        this.registry.counter(RATIS_SERVER_FAILED_CLIENT_READ_COUNT).inc();
    }

    void onFailedClientWatch() {
        this.registry.counter(RATIS_SERVER_FAILED_CLIENT_WATCH_COUNT).inc();
    }

    void onFailedClientWrite() {
        this.registry.counter(RATIS_SERVER_FAILED_CLIENT_WRITE_COUNT).inc();
    }

    void onFailedClientStream() {
        this.registry.counter(RATIS_SERVER_FAILED_CLIENT_STREAM_COUNT).inc();
    }

    public void incFailedRequestCount(RaftClientRequest.Type type) {
        if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            this.onFailedClientStaleRead();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            this.onFailedClientWatch();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE)) {
            this.onFailedClientWrite();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
            this.onFailedClientRead();
        } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM)) {
            this.onFailedClientStream();
        }
    }

    public void onSnapshotInstalled() {
        this.registry.counter(RATIS_SERVER_INSTALL_SNAPSHOT_COUNT).inc();
    }

    public RatisMetricRegistry getRegistry() {
        return this.registry;
    }

    private static /* synthetic */ Object lambda$null$10(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).missRate();
    }

    private static /* synthetic */ Object lambda$null$8(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).missCount();
    }

    private static /* synthetic */ Object lambda$null$6(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).hitRate();
    }

    private static /* synthetic */ Object lambda$null$4(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).hitCount();
    }

    private static /* synthetic */ Object lambda$null$2(Supplier retryCacheStatistics) {
        return ((RetryCache.Statistics)retryCacheStatistics.get()).size();
    }
}

