/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverClientRatis
extends XceiverClientSpi {
    public static final Logger LOG = LoggerFactory.getLogger(XceiverClientRatis.class);
    private final Pipeline pipeline;
    private final RpcType rpcType;
    private final AtomicReference<RaftClient> client = new AtomicReference();
    private final RetryPolicy retryPolicy;
    private final GrpcTlsConfig tlsConfig;
    private final ConfigurationSource ozoneConfiguration;
    private final ConcurrentHashMap<UUID, Long> commitInfoMap;
    private XceiverClientMetrics metrics;

    public static XceiverClientRatis newXceiverClientRatis(Pipeline pipeline, ConfigurationSource ozoneConf) {
        return XceiverClientRatis.newXceiverClientRatis(pipeline, ozoneConf, null);
    }

    public static XceiverClientRatis newXceiverClientRatis(Pipeline pipeline, ConfigurationSource ozoneConf, X509Certificate caCert) {
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy((ConfigurationSource)ozoneConf);
        GrpcTlsConfig tlsConfig = RatisHelper.createTlsClientConfig((SecurityConfig)new SecurityConfig(ozoneConf), (X509Certificate)caCert);
        return new XceiverClientRatis(pipeline, (RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), retryPolicy, tlsConfig, ozoneConf);
    }

    private XceiverClientRatis(Pipeline pipeline, RpcType rpcType, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource configuration) {
        this.pipeline = pipeline;
        this.rpcType = rpcType;
        this.retryPolicy = retryPolicy;
        this.commitInfoMap = new ConcurrentHashMap();
        this.tlsConfig = tlsConfig;
        this.metrics = XceiverClientManager.getXceiverClientMetrics();
        this.ozoneConfiguration = configuration;
    }

    private void updateCommitInfosMap(Collection<RaftProtos.CommitInfoProto> commitInfoProtos) {
        if (this.commitInfoMap.isEmpty()) {
            commitInfoProtos.forEach(proto -> this.commitInfoMap.put(RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)proto.getServer()), proto.getCommitIndex()));
        } else {
            commitInfoProtos.forEach(proto -> this.commitInfoMap.computeIfPresent(RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)proto.getServer()), (address, index) -> {
                index = proto.getCommitIndex();
                return index;
            }));
        }
    }

    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void connect() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting to pipeline:{} datanode:{}", (Object)this.getPipeline().getId(), (Object)RatisHelper.toRaftPeerId((DatanodeDetails)this.pipeline.getFirstNode()));
        }
        if (!this.client.compareAndSet(null, RatisHelper.newRaftClient((RpcType)this.rpcType, (Pipeline)this.getPipeline(), (RetryPolicy)this.retryPolicy, (GrpcTlsConfig)this.tlsConfig, (ConfigurationSource)this.ozoneConfiguration))) {
            throw new IllegalStateException("Client is already connected.");
        }
    }

    public void connect(String encodedToken) throws Exception {
        throw new UnsupportedOperationException("Block tokens are not implemented for Ratis clients.");
    }

    public void close() {
        RaftClient c = this.client.getAndSet(null);
        if (c != null) {
            this.closeRaftClient(c);
        }
    }

    private void closeRaftClient(RaftClient raftClient) {
        try {
            raftClient.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private RaftClient getClient() {
        return Objects.requireNonNull(this.client.get(), "client is null");
    }

    @VisibleForTesting
    public ConcurrentMap<UUID, Long> getCommitInfoMap() {
        return this.commitInfoMap;
    }

    private CompletableFuture<RaftClientReply> sendRequestAsync(ContainerProtos.ContainerCommandRequestProto request) {
        return (CompletableFuture)TracingUtil.executeInNewSpan((String)("XceiverClientRatis." + request.getCmdType().name()), () -> {
            ContainerCommandRequestMessage message = ContainerCommandRequestMessage.toMessage((ContainerProtos.ContainerCommandRequestProto)request, (String)TracingUtil.exportCurrentSpan());
            if (HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)request)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendCommandAsync ReadOnly {}", (Object)message);
                }
                return this.getClient().async().sendReadOnly((Message)message);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendCommandAsync {}", (Object)message);
            }
            return this.getClient().async().send((Message)message);
        });
    }

    public long getReplicatedMinCommitIndex() {
        OptionalLong minIndex = this.commitInfoMap.values().parallelStream().mapToLong(v -> v).min();
        return minIndex.isPresent() ? minIndex.getAsLong() : 0L;
    }

    private void addDatanodetoReply(UUID address, XceiverClientReply reply) {
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(address);
        reply.addDatanode(builder.build());
    }

    public XceiverClientReply watchForCommit(long index) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        long commitIndex = this.getReplicatedMinCommitIndex();
        XceiverClientReply clientReply = new XceiverClientReply(null);
        if (commitIndex >= index) {
            clientReply.setLogIndex(commitIndex);
            return clientReply;
        }
        try {
            CompletableFuture replyFuture = this.getClient().async().watch(index, RaftProtos.ReplicationLevel.ALL_COMMITTED);
            replyFuture.get();
        }
        catch (Exception e) {
            Throwable t = HddsClientUtils.checkForException(e);
            LOG.warn("3 way commit failed on pipeline {}", (Object)this.pipeline, (Object)e);
            if (t instanceof GroupMismatchException) {
                throw e;
            }
            RaftClientReply reply = (RaftClientReply)this.getClient().async().watch(index, RaftProtos.ReplicationLevel.MAJORITY_COMMITTED).get();
            List commitInfoProtoList = reply.getCommitInfos().stream().filter(i -> i.getCommitIndex() < index).collect(Collectors.toList());
            commitInfoProtoList.parallelStream().forEach(proto -> {
                UUID address = RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)proto.getServer());
                this.addDatanodetoReply(address, clientReply);
                this.commitInfoMap.remove(address);
                LOG.info("Could not commit index {} on pipeline {} to all the nodes. Server {} has failed. Committed by majority.", new Object[]{index, this.pipeline, address});
            });
        }
        clientReply.setLogIndex(index);
        return clientReply;
    }

    public XceiverClientReply sendCommandAsync(ContainerProtos.ContainerCommandRequestProto request) {
        XceiverClientReply asyncReply = new XceiverClientReply(null);
        long requestTime = System.currentTimeMillis();
        CompletableFuture<RaftClientReply> raftClientReply = this.sendRequestAsync(request);
        this.metrics.incrPendingContainerOpsMetrics(request.getCmdType());
        CompletionStage containerCommandResponse = ((CompletableFuture)raftClientReply.whenComplete((reply, e) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received reply {} for request: cmdType={} containerID={} pipelineID={} traceID={} exception: {}", new Object[]{reply, request.getCmdType(), request.getContainerID(), request.getPipelineID(), request.getTraceID(), e});
            }
            this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
            this.metrics.addContainerOpsLatency(request.getCmdType(), System.currentTimeMillis() - requestTime);
        })).thenApply(reply -> {
            try {
                if (!reply.isSuccess()) {
                    RaftException exception = reply.getException();
                    Preconditions.checkNotNull((Object)exception, (Object)"Raft reply failure but no exception propagated.");
                    throw new CompletionException((Throwable)exception);
                }
                ContainerProtos.ContainerCommandResponseProto response = ContainerProtos.ContainerCommandResponseProto.parseFrom((ByteString)reply.getMessage().getContent());
                UUID serverId = RatisHelper.toDatanodeId((String)reply.getReplierId());
                if (response.getResult() == ContainerProtos.Result.SUCCESS) {
                    this.updateCommitInfosMap(reply.getCommitInfos());
                }
                asyncReply.setLogIndex(reply.getLogIndex());
                this.addDatanodetoReply(serverId, asyncReply);
                return response;
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompletionException(e);
            }
        });
        asyncReply.setResponse((CompletableFuture)containerCommandResponse);
        return asyncReply;
    }

    public Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> sendCommandOnAllNodes(ContainerProtos.ContainerCommandRequestProto request) {
        throw new UnsupportedOperationException("Operation Not supported for ratis client");
    }
}

