/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.db.SequenceNumberNotFoundException;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerDoubleBuffer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.protocolPB.RequestHandler;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerRequestHandler
implements RequestHandler {
    static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRequestHandler.class);
    private final OzoneManager impl;
    private OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer;

    public OzoneManagerRequestHandler(OzoneManager om, OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer) {
        this.impl = om;
        this.ozoneManagerDoubleBuffer = ozoneManagerDoubleBuffer;
    }

    @Override
    public OzoneManagerProtocolProtos.OMResponse handleReadRequest(OzoneManagerProtocolProtos.OMRequest request) {
        OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder;
        block21: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received OMRequest: {}, ", (Object)request);
            }
            OzoneManagerProtocolProtos.Type cmdType = request.getCmdType();
            responseBuilder = OmResponseUtil.getOMResponseBuilder(request);
            try {
                switch (cmdType) {
                    case CheckVolumeAccess: {
                        OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccessResponse = this.checkVolumeAccess(request.getCheckVolumeAccessRequest());
                        responseBuilder.setCheckVolumeAccessResponse(checkVolumeAccessResponse);
                        break;
                    }
                    case InfoVolume: {
                        OzoneManagerProtocolProtos.InfoVolumeResponse infoVolumeResponse = this.infoVolume(request.getInfoVolumeRequest());
                        responseBuilder.setInfoVolumeResponse(infoVolumeResponse);
                        break;
                    }
                    case ListVolume: {
                        OzoneManagerProtocolProtos.ListVolumeResponse listVolumeResponse = this.listVolumes(request.getListVolumeRequest());
                        responseBuilder.setListVolumeResponse(listVolumeResponse);
                        break;
                    }
                    case InfoBucket: {
                        OzoneManagerProtocolProtos.InfoBucketResponse infoBucketResponse = this.infoBucket(request.getInfoBucketRequest());
                        responseBuilder.setInfoBucketResponse(infoBucketResponse);
                        break;
                    }
                    case ListBuckets: {
                        OzoneManagerProtocolProtos.ListBucketsResponse listBucketsResponse = this.listBuckets(request.getListBucketsRequest());
                        responseBuilder.setListBucketsResponse(listBucketsResponse);
                        break;
                    }
                    case LookupKey: {
                        OzoneManagerProtocolProtos.LookupKeyResponse lookupKeyResponse = this.lookupKey(request.getLookupKeyRequest(), request.getVersion());
                        responseBuilder.setLookupKeyResponse(lookupKeyResponse);
                        break;
                    }
                    case ListKeys: {
                        OzoneManagerProtocolProtos.ListKeysResponse listKeysResponse = this.listKeys(request.getListKeysRequest(), request.getVersion());
                        responseBuilder.setListKeysResponse(listKeysResponse);
                        break;
                    }
                    case ListTrash: {
                        OzoneManagerProtocolProtos.ListTrashResponse listTrashResponse = this.listTrash(request.getListTrashRequest(), request.getVersion());
                        responseBuilder.setListTrashResponse(listTrashResponse);
                        break;
                    }
                    case ListMultiPartUploadParts: {
                        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse listPartsResponse = this.listParts(request.getListMultipartUploadPartsRequest());
                        responseBuilder.setListMultipartUploadPartsResponse(listPartsResponse);
                        break;
                    }
                    case ListMultipartUploads: {
                        OzoneManagerProtocolProtos.ListMultipartUploadsResponse response = this.listMultipartUploads(request.getListMultipartUploadsRequest());
                        responseBuilder.setListMultipartUploadsResponse(response);
                        break;
                    }
                    case ServiceList: {
                        OzoneManagerProtocolProtos.ServiceListResponse serviceListResponse = this.getServiceList(request.getServiceListRequest());
                        responseBuilder.setServiceListResponse(serviceListResponse);
                        break;
                    }
                    case DBUpdates: {
                        OzoneManagerProtocolProtos.DBUpdatesResponse dbUpdatesResponse = this.getOMDBUpdates(request.getDbUpdatesRequest());
                        responseBuilder.setDbUpdatesResponse(dbUpdatesResponse);
                        break;
                    }
                    case GetFileStatus: {
                        OzoneManagerProtocolProtos.GetFileStatusResponse getFileStatusResponse = this.getOzoneFileStatus(request.getGetFileStatusRequest(), request.getVersion());
                        responseBuilder.setGetFileStatusResponse(getFileStatusResponse);
                        break;
                    }
                    case LookupFile: {
                        OzoneManagerProtocolProtos.LookupFileResponse lookupFileResponse = this.lookupFile(request.getLookupFileRequest(), request.getVersion());
                        responseBuilder.setLookupFileResponse(lookupFileResponse);
                        break;
                    }
                    case ListStatus: {
                        OzoneManagerProtocolProtos.ListStatusResponse listStatusResponse = this.listStatus(request.getListStatusRequest(), request.getVersion());
                        responseBuilder.setListStatusResponse(listStatusResponse);
                        break;
                    }
                    case GetAcl: {
                        OzoneManagerProtocolProtos.GetAclResponse getAclResponse = this.getAcl(request.getGetAclRequest());
                        responseBuilder.setGetAclResponse(getAclResponse);
                        break;
                    }
                    default: {
                        responseBuilder.setSuccess(false);
                        responseBuilder.setMessage("Unrecognized Command Type: " + cmdType);
                    }
                }
                responseBuilder.setSuccess(true);
            }
            catch (IOException ex) {
                responseBuilder.setSuccess(false);
                responseBuilder.setStatus(this.exceptionToResponseStatus(ex));
                if (ex.getMessage() == null) break block21;
                responseBuilder.setMessage(ex.getMessage());
            }
        }
        return responseBuilder.build();
    }

    @Override
    public OMClientResponse handleWriteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, long transactionLogIndex) {
        OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(omRequest);
        OMClientResponse omClientResponse = omClientRequest.validateAndUpdateCache(this.getOzoneManager(), transactionLogIndex, this.ozoneManagerDoubleBuffer::add);
        return omClientResponse;
    }

    @Override
    public void updateDoubleBuffer(OzoneManagerDoubleBuffer omDoubleBuffer) {
        this.ozoneManagerDoubleBuffer = omDoubleBuffer;
    }

    private OzoneManagerProtocolProtos.DBUpdatesResponse getOMDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws SequenceNumberNotFoundException {
        OzoneManagerProtocolProtos.DBUpdatesResponse.Builder builder = OzoneManagerProtocolProtos.DBUpdatesResponse.newBuilder();
        DBUpdates dbUpdatesWrapper = this.impl.getDBUpdates(dbUpdatesRequest);
        for (int i = 0; i < dbUpdatesWrapper.getData().size(); ++i) {
            builder.addData(OMPBHelper.getByteString((byte[])((byte[])dbUpdatesWrapper.getData().get(i))));
        }
        builder.setSequenceNumber(dbUpdatesWrapper.getCurrentSequenceNumber());
        return builder.build();
    }

    private OzoneManagerProtocolProtos.GetAclResponse getAcl(OzoneManagerProtocolProtos.GetAclRequest req) throws IOException {
        ArrayList acls = new ArrayList();
        List<OzoneAcl> aclList = this.impl.getAcl((OzoneObj)OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)req.getObj()));
        if (aclList != null) {
            aclList.forEach(a -> acls.add(OzoneAcl.toProtobuf((OzoneAcl)a)));
        }
        return OzoneManagerProtocolProtos.GetAclResponse.newBuilder().addAllAcls(acls).build();
    }

    protected OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)ex).getResult().ordinal()];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unknown error occurs", (Throwable)ex);
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    @Override
    public void validateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws OMException {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        if (cmdType == null) {
            throw new OMException("CmdType is null", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (omRequest.getClientId() == null) {
            throw new OMException("ClientId is null", OMException.ResultCodes.INVALID_REQUEST);
        }
    }

    private OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccess(OzoneManagerProtocolProtos.CheckVolumeAccessRequest request) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessResponse.Builder resp = OzoneManagerProtocolProtos.CheckVolumeAccessResponse.newBuilder();
        boolean access = this.impl.checkVolumeAccess(request.getVolumeName(), request.getUserAcl());
        if (!access) {
            throw new OMException(OMException.ResultCodes.ACCESS_DENIED);
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.InfoVolumeResponse infoVolume(OzoneManagerProtocolProtos.InfoVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeResponse.Builder resp = OzoneManagerProtocolProtos.InfoVolumeResponse.newBuilder();
        String volume = request.getVolumeName();
        OmVolumeArgs ret = this.impl.getVolumeInfo(volume);
        resp.setVolumeInfo(ret.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListVolumeResponse listVolumes(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeResponse.Builder resp = OzoneManagerProtocolProtos.ListVolumeResponse.newBuilder();
        List<Object> result = Lists.newArrayList();
        if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER) {
            result = this.impl.listVolumeByUser(request.getUserName(), request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
        } else if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER) {
            result = this.impl.listAllVolumes(request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
        }
        result.forEach(item -> resp.addVolumeInfo(item.getProtobuf()));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.InfoBucketResponse infoBucket(OzoneManagerProtocolProtos.InfoBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketResponse.Builder resp = OzoneManagerProtocolProtos.InfoBucketResponse.newBuilder();
        OmBucketInfo omBucketInfo = this.impl.getBucketInfo(request.getVolumeName(), request.getBucketName());
        resp.setBucketInfo(omBucketInfo.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.LookupKeyResponse lookupKey(OzoneManagerProtocolProtos.LookupKeyRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.LookupKeyResponse.Builder resp = OzoneManagerProtocolProtos.LookupKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setRefreshPipeline(true).setSortDatanodesInPipeline(keyArgs.getSortDatanodes()).build();
        OmKeyInfo keyInfo = this.impl.lookupKey(omKeyArgs);
        resp.setKeyInfo(keyInfo.getProtobuf(false, clientVersion));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListBucketsResponse listBuckets(OzoneManagerProtocolProtos.ListBucketsRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListBucketsResponse.Builder resp = OzoneManagerProtocolProtos.ListBucketsResponse.newBuilder();
        List<OmBucketInfo> buckets = this.impl.listBuckets(request.getVolumeName(), request.getStartKey(), request.getPrefix(), request.getCount());
        for (OmBucketInfo bucket : buckets) {
            resp.addBucketInfo(bucket.getProtobuf());
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListKeysResponse listKeys(OzoneManagerProtocolProtos.ListKeysRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.ListKeysResponse.Builder resp = OzoneManagerProtocolProtos.ListKeysResponse.newBuilder();
        List<OmKeyInfo> keys = this.impl.listKeys(request.getVolumeName(), request.getBucketName(), request.getStartKey(), request.getPrefix(), request.getCount());
        for (OmKeyInfo key : keys) {
            resp.addKeyInfo(key.getProtobuf(true, clientVersion));
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListTrashResponse listTrash(OzoneManagerProtocolProtos.ListTrashRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.ListTrashResponse.Builder resp = OzoneManagerProtocolProtos.ListTrashResponse.newBuilder();
        List<RepeatedOmKeyInfo> deletedKeys = this.impl.listTrash(request.getVolumeName(), request.getBucketName(), request.getStartKeyName(), request.getKeyPrefix(), request.getMaxKeys());
        for (RepeatedOmKeyInfo key : deletedKeys) {
            resp.addDeletedKeys(key.getProto(false, clientVersion));
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.AllocateBlockResponse allocateBlock(OzoneManagerProtocolProtos.AllocateBlockRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockResponse.Builder resp = OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
        OmKeyLocationInfo newLocation = this.impl.allocateBlock(omKeyArgs, request.getClientID(), ExcludeList.getFromProtoBuf((HddsProtos.ExcludeListProto)request.getExcludeList()));
        resp.setKeyLocation(newLocation.getProtobuf(clientVersion));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ServiceListResponse getServiceList(OzoneManagerProtocolProtos.ServiceListRequest request) throws IOException {
        OzoneManagerProtocolProtos.ServiceListResponse.Builder resp = OzoneManagerProtocolProtos.ServiceListResponse.newBuilder();
        ServiceInfoEx serviceInfoEx = this.impl.getServiceInfo();
        ArrayList<OzoneManagerProtocolProtos.ServiceInfo> serviceInfoProtos = new ArrayList<OzoneManagerProtocolProtos.ServiceInfo>();
        List serviceInfos = serviceInfoEx.getServiceInfoList();
        for (ServiceInfo info : serviceInfos) {
            serviceInfoProtos.add(info.getProtobuf());
        }
        resp.addAllServiceInfo(serviceInfoProtos);
        if (serviceInfoEx.getCaCertificate() != null) {
            resp.setCaCertificate(serviceInfoEx.getCaCertificate());
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.MultipartUploadListPartsResponse listParts(OzoneManagerProtocolProtos.MultipartUploadListPartsRequest multipartUploadListPartsRequest) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse.Builder response = OzoneManagerProtocolProtos.MultipartUploadListPartsResponse.newBuilder();
        OmMultipartUploadListParts omMultipartUploadListParts = this.impl.listParts(multipartUploadListPartsRequest.getVolume(), multipartUploadListPartsRequest.getBucket(), multipartUploadListPartsRequest.getKey(), multipartUploadListPartsRequest.getUploadID(), multipartUploadListPartsRequest.getPartNumbermarker(), multipartUploadListPartsRequest.getMaxParts());
        List omPartInfoList = omMultipartUploadListParts.getPartInfoList();
        ArrayList partInfoList = new ArrayList();
        omPartInfoList.forEach(partInfo -> partInfoList.add(partInfo.getProto()));
        response.setType(omMultipartUploadListParts.getReplicationType());
        response.setFactor(omMultipartUploadListParts.getReplicationFactor());
        response.setNextPartNumberMarker(omMultipartUploadListParts.getNextPartNumberMarker());
        response.setIsTruncated(omMultipartUploadListParts.isTruncated());
        return response.addAllPartsList(partInfoList).build();
    }

    private OzoneManagerProtocolProtos.ListMultipartUploadsResponse listMultipartUploads(OzoneManagerProtocolProtos.ListMultipartUploadsRequest request) throws IOException {
        OmMultipartUploadList omMultipartUploadList = this.impl.listMultipartUploads(request.getVolume(), request.getBucket(), request.getPrefix());
        List info = omMultipartUploadList.getUploads().stream().map(upload -> OzoneManagerProtocolProtos.MultipartUploadInfo.newBuilder().setVolumeName(upload.getVolumeName()).setBucketName(upload.getBucketName()).setKeyName(upload.getKeyName()).setUploadId(upload.getUploadId()).setType(upload.getReplicationType()).setFactor(upload.getReplicationFactor()).setCreationTime(upload.getCreationTime().toEpochMilli()).build()).collect(Collectors.toList());
        OzoneManagerProtocolProtos.ListMultipartUploadsResponse response = OzoneManagerProtocolProtos.ListMultipartUploadsResponse.newBuilder().addAllUploadsList(info).build();
        return response;
    }

    private OzoneManagerProtocolProtos.GetFileStatusResponse getOzoneFileStatus(OzoneManagerProtocolProtos.GetFileStatusRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setRefreshPipeline(true).build();
        OzoneManagerProtocolProtos.GetFileStatusResponse.Builder rb = OzoneManagerProtocolProtos.GetFileStatusResponse.newBuilder();
        rb.setStatus(this.impl.getFileStatus(omKeyArgs).getProtobuf(clientVersion));
        return rb.build();
    }

    private OzoneManagerProtocolProtos.LookupFileResponse lookupFile(OzoneManagerProtocolProtos.LookupFileRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setRefreshPipeline(true).setSortDatanodesInPipeline(keyArgs.getSortDatanodes()).build();
        return OzoneManagerProtocolProtos.LookupFileResponse.newBuilder().setKeyInfo(this.impl.lookupFile(omKeyArgs).getProtobuf(clientVersion)).build();
    }

    private OzoneManagerProtocolProtos.ListStatusResponse listStatus(OzoneManagerProtocolProtos.ListStatusRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setRefreshPipeline(true).build();
        List<OzoneFileStatus> statuses = this.impl.listStatus(omKeyArgs, request.getRecursive(), request.getStartKey(), request.getNumEntries());
        OzoneManagerProtocolProtos.ListStatusResponse.Builder listStatusResponseBuilder = OzoneManagerProtocolProtos.ListStatusResponse.newBuilder();
        for (OzoneFileStatus status : statuses) {
            listStatusResponseBuilder.addStatuses(status.getProtobuf(clientVersion));
        }
        return listStatusResponseBuilder.build();
    }

    protected OzoneManager getOzoneManager() {
        return this.impl;
    }
}

