/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable"})
public class OMKeyRenameResponse
extends OMClientResponse {
    private String fromKeyName;
    private String toKeyName;
    private OmKeyInfo renameKeyInfo;

    public OMKeyRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String fromKeyName, String toKeyName, @Nonnull OmKeyInfo renameKeyInfo) {
        super(omResponse);
        this.fromKeyName = fromKeyName;
        this.toKeyName = toKeyName;
        this.renameKeyInfo = renameKeyInfo;
    }

    public OMKeyRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = this.renameKeyInfo.getVolumeName();
        String bucketName = this.renameKeyInfo.getBucketName();
        omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(volumeName, bucketName, this.fromKeyName));
        omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(volumeName, bucketName, this.toKeyName), (Object)this.renameKeyInfo);
    }
}

