/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.bucket;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"bucketTable"})
public final class OMBucketDeleteResponse
extends OMClientResponse {
    private String volumeName;
    private String bucketName;
    private final OmVolumeArgs omVolumeArgs;

    public OMBucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String volumeName, String bucketName, OmVolumeArgs volumeArgs) {
        super(omResponse);
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.omVolumeArgs = volumeArgs;
    }

    public OMBucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String volumeName, String bucketName) {
        super(omResponse);
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.omVolumeArgs = null;
    }

    public OMBucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
        this.omVolumeArgs = null;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String dbBucketKey = omMetadataManager.getBucketKey(this.volumeName, this.bucketName);
        omMetadataManager.getBucketTable().deleteWithBatch(batchOperation, (Object)dbBucketKey);
        if (this.omVolumeArgs != null) {
            omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)omMetadataManager.getVolumeKey(this.omVolumeArgs.getVolume()), (Object)this.omVolumeArgs);
        }
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }
}

