/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeAclOpResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeRemoveAclRequest
extends OMVolumeAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeRemoveAclRequest.class);
    private static CheckedBiFunction<List<OzoneAcl>, OmVolumeArgs, IOException> volumeRemoveAclOp = (acls, volArgs) -> volArgs.removeAcl((OzoneAcl)acls.get(0));
    private List<OzoneAcl> ozoneAcls;
    private String volumeName;
    private OzoneObj obj;

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.RemoveAclRequest.Builder removeAclRequestBuilder = this.getOmRequest().getRemoveAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setRemoveAclRequest(removeAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMVolumeRemoveAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, volumeRemoveAclOp);
        OzoneManagerProtocolProtos.RemoveAclRequest removeAclRequest = this.getOmRequest().getRemoveAclRequest();
        Preconditions.checkNotNull((Object)removeAclRequest);
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)removeAclRequest.getAcl())});
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)removeAclRequest.getObj());
        this.volumeName = this.obj.getPath().substring(1);
    }

    @Override
    public List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    private OzoneAcl getAcl() {
        return this.ozoneAcls.get(0);
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmVolumeArgs omVolumeArgs, boolean aclApplied) {
        omResponse.setRemoveAclResponse(OzoneManagerProtocolProtos.RemoveAclResponse.newBuilder().setResponse(aclApplied).build());
        return new OMVolumeAclOpResponse(omResponse.build(), omVolumeArgs);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException ex) {
        return new OMVolumeAclOpResponse(this.createErrorOMResponse(omResponse, ex));
    }

    @Override
    void onComplete(OMClientRequest.Result result, IOException ex, long trxnLogIndex, AuditLogger auditLogger, Map<String, String> auditMap) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Remove acl: {} from volume: {} success!", (Object)this.getAcl(), (Object)this.getVolumeName());
                break;
            }
            case FAILURE: {
                LOG.error("Remove acl {} from volume {} failed!", new Object[]{this.getAcl(), this.getVolumeName(), ex});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMVolumeRemoveAclRequest: {}", (Object)this.getOmRequest());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.REMOVE_ACL, auditMap, ex, this.getOmRequest().getUserInfo()));
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        ozoneManager.getMetrics().incNumRemoveAcl();
        return super.validateAndUpdateCache(ozoneManager, trxnLogIndex, omDoubleBufferHelper);
    }
}

