/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeCreateRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeCreateRequest.class);

    public OMVolumeCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = this.getOmRequest().getCreateVolumeRequest().getVolumeInfo();
        OmUtils.validateVolumeName((String)volumeInfo.getVolume());
        long initialTime = Time.now();
        OzoneManagerProtocolProtos.VolumeInfo updatedVolumeInfo = volumeInfo.toBuilder().setCreationTime(initialTime).setModificationTime(initialTime).build();
        return this.getOmRequest().toBuilder().setCreateVolumeRequest(OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder().setVolumeInfo(updatedVolumeInfo)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block15: {
            createVolumeRequest = this.getOmRequest().getCreateVolumeRequest();
            Preconditions.checkNotNull((Object)createVolumeRequest);
            volumeInfo = createVolumeRequest.getVolumeInfo();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeCreates();
            volume = volumeInfo.getVolume();
            owner = volumeInfo.getOwnerName();
            omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omMetadataManager = ozoneManager.getMetadataManager();
            acquiredVolumeLock = false;
            acquiredUserLock = false;
            exception = null;
            omClientResponse = null;
            omVolumeArgs = null;
            auditMap = new HashMap<K, V>();
            try {
                omVolumeArgs = OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)volumeInfo);
                omVolumeArgs.setObjectID(ozoneManager.getObjectIdFromTxId(transactionLogIndex));
                omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
                auditMap = omVolumeArgs.toAuditMap();
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volume, null, null);
                }
                acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                acquiredUserLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                dbVolumeKey = omMetadataManager.getVolumeKey(volume);
                volumeList = null;
                if (omMetadataManager.getVolumeTable().isExist((Object)dbVolumeKey)) {
                    OMVolumeCreateRequest.LOG.debug("volume:{} already exists", (Object)omVolumeArgs.getVolume());
                    throw new OMException("Volume already exists", OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                }
                dbUserKey = omMetadataManager.getUserKey(owner);
                volumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)dbUserKey);
                volumeList = this.addVolumeToOwnerList(volumeList, volume, owner, ozoneManager.getMaxUserVolumeCount(), transactionLogIndex);
                this.createVolume(omMetadataManager, omVolumeArgs, volumeList, dbVolumeKey, dbUserKey, transactionLogIndex);
                omResponse.setCreateVolumeResponse(OzoneManagerProtocolProtos.CreateVolumeResponse.newBuilder().build());
                omClientResponse = new OMVolumeCreateResponse(omResponse.build(), omVolumeArgs, volumeList);
                OMVolumeCreateRequest.LOG.debug("volume:{} successfully created", (Object)omVolumeArgs.getVolume());
                if (omClientResponse != null) {
                    omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                }
                if (!acquiredUserLock) break block15;
            }
            catch (IOException ex) {
                block16: {
                    try {
                        exception = ex;
                        omClientResponse = new OMVolumeCreateResponse(this.createErrorOMResponse(omResponse, exception));
                        if (omClientResponse != null) {
                            omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                        }
                        if (!acquiredUserLock) break block16;
                    }
                    catch (Throwable var21_21) {
                        if (omClientResponse != null) {
                            omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                        }
                        if (acquiredUserLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                        }
                        if (acquiredVolumeLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                        }
                        throw var21_21;
                    }
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                } else {
                    ** GOTO lbl67
                }
            }
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        if (acquiredVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_VOLUME, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            OMVolumeCreateRequest.LOG.info("created volume:{} for user:{}", (Object)volume, (Object)owner);
            omMetrics.incNumVolumes();
        } else {
            OMVolumeCreateRequest.LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{owner, volume, exception});
            omMetrics.incNumVolumeCreateFails();
        }
        return omClientResponse;
    }

    @VisibleForTesting
    public static Logger getLogger() {
        return LOG;
    }
}

