/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCommitPartRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3MultipartUploadCommitPartRequest.class);

    public S3MultipartUploadCommitPartRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
        return this.getOmRequest().toBuilder().setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(S3MultipartUploadCommitPartRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyArgs.getKeyName())))).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
        auditMap = this.buildKeyArgsAuditMap(keyArgs);
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        ozoneManager.getMetrics().incNumCommitMultipartUploadParts();
        acquiredLock = false;
        exception = null;
        partName = null;
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omClientResponse = null;
        oldPartKeyInfo = null;
        openKey = null;
        omKeyInfo = null;
        multipartKey = null;
        multipartKeyInfo = null;
        result = null;
        omBucketInfo = null;
        copyBucketInfo = null;
        try {
            keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, OzoneObj.ResourceType.KEY);
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            uploadID = keyArgs.getMultipartUploadID();
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
            clientID = multipartCommitUploadPartRequest.getClientID();
            openKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)openKey);
            if (omKeyInfo == null) {
                throw new OMException("Failed to commit Multipart Upload key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            omKeyInfo.setDataSize(keyArgs.getDataSize());
            omKeyInfo.updateLocationInfoList(keyArgs.getKeyLocationsList().stream().map((Function<OzoneManagerProtocolProtos.KeyLocation, OmKeyLocationInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFromProtobuf(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$KeyLocation ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$KeyLocation;)Lorg/apache/hadoop/ozone/om/helpers/OmKeyLocationInfo;)()).collect(Collectors.toList()), true);
            omKeyInfo.setModificationTime(keyArgs.getModificationTime());
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            partName = ozoneKey + clientID;
            if (multipartKeyInfo == null) {
                throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            partNumber = keyArgs.getMultipartNumber();
            oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
            partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
            partKeyInfo.setPartName(partName);
            partKeyInfo.setPartNumber(partNumber);
            partKeyInfo.setPartKeyInfo(omKeyInfo.getProtobuf(this.getOmRequest().getVersion()));
            multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
            multipartKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), trxnLogIndex));
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)openKey), new CacheValue(Optional.absent(), trxnLogIndex));
            scmBlockSize = ozoneManager.getScmBlockSize();
            factor = omKeyInfo.getFactor().getNumber();
            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
            correctedSpace = omKeyInfo.getDataSize() * (long)factor - (long)keyArgs.getKeyLocationsList().size() * scmBlockSize * (long)factor;
            omBucketInfo.incrUsedBytes(correctedSpace);
            omResponse.setCommitMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.newBuilder().setPartName(partName));
            omClientResponse = new S3MultipartUploadCommitPartResponse(omResponse.build(), multipartKey, openKey, multipartKeyInfo, oldPartKeyInfo, omKeyInfo, ozoneManager.isRatisEnabled(), omBucketInfo.copyObject());
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omClientResponse = new S3MultipartUploadCommitPartResponse(this.createErrorOMResponse(omResponse, exception), multipartKey, openKey, multipartKeyInfo, oldPartKeyInfo, omKeyInfo, ozoneManager.isRatisEnabled(), copyBucketInfo);
            }
            catch (Throwable var36_33) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var36_33;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl85
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        auditMap.put("partNumber", String.valueOf(keyArgs.getMultipartNumber()));
        auditMap.put("partName", partName);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                S3MultipartUploadCommitPartRequest.LOG.debug("MultipartUpload Commit is successfully for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case 2: {
                ozoneManager.getMetrics().incNumCommitMultipartUploadPartFails();
                S3MultipartUploadCommitPartRequest.LOG.error("MultipartUpload Commit is failed for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                S3MultipartUploadCommitPartRequest.LOG.error("Unrecognized Result for S3MultipartUploadCommitPartRequest: {}", (Object)multipartCommitUploadPartRequest);
            }
        }
        return omClientResponse;
    }
}

