/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMKeyAclRequest
extends OMClientRequest {
    public OMKeyAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        omKeyInfo = null;
        omResponse = this.onInit();
        omClientResponse = null;
        exception = null;
        omMetadataManager = ozoneManager.getMetadataManager();
        lockAcquired = false;
        volume = null;
        bucket = null;
        key = null;
        operationResult = false;
        result = null;
        try {
            objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY);
            volume = objectParser.getVolume();
            bucket = objectParser.getBucket();
            key = objectParser.getKey();
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
            }
            lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            dbKey = omMetadataManager.getOzoneKey(volume, bucket, key);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)dbKey);
            if (omKeyInfo == null) {
                throw new OMException(OMException.ResultCodes.KEY_NOT_FOUND);
            }
            operationResult = this.apply(omKeyInfo, trxnLogIndex);
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            modificationTime = omKeyInfo.getModificationTime();
            if (this.getOmRequest().getAddAclRequest().hasObj() && operationResult) {
                modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
            } else if (this.getOmRequest().getSetAclRequest().hasObj()) {
                modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
            } else if (this.getOmRequest().getRemoveAclRequest().hasObj() && operationResult) {
                modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
            }
            omKeyInfo.setModificationTime(modificationTime);
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbKey), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
            omClientResponse = this.onSuccess(omResponse, omKeyInfo, operationResult);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omClientResponse = this.onFailure(omResponse, ex);
            }
            catch (Throwable var20_19) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (lockAcquired) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                }
                throw var20_19;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            } else {
                ** GOTO lbl57
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (lockAcquired) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        }
        obj = this.getObject();
        auditMap = obj.toAuditMap();
        this.onComplete(result, operationResult, exception, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract String getPath();

    abstract OzoneObj getObject();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmKeyInfo var2, boolean var3);

    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException exception) {
        return new OMKeyAclResponse(this.createErrorOMResponse(omResponse, exception));
    }

    abstract void onComplete(OMClientRequest.Result var1, boolean var2, IOException var3, long var4, AuditLogger var6, Map<String, String> var7);

    abstract boolean apply(OmKeyInfo var1, long var2);
}

