/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysRenameResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeysRenameRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeysRenameRequest.class);

    public OMKeysRenameRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        renameKeysRequest = this.getOmRequest().getRenameKeysRequest();
        renameKeysArgs = renameKeysRequest.getRenameKeysArgs();
        volumeName = renameKeysArgs.getVolumeName();
        bucketName = renameKeysArgs.getBucketName();
        omClientResponse = null;
        unRenamedKeys = new ArrayList<OzoneManagerProtocolProtos.RenameKeysMap>();
        renamedKeys = new HashMap<String, String>();
        fromKeyAndToKeyInfo = new HashMap<String, OmKeyInfo>();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyRenames();
        auditLogger = ozoneManager.getAuditLogger();
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        omMetadataManager = ozoneManager.getMetadataManager();
        exception = null;
        fromKeyValue = null;
        result = null;
        auditMap /* !! */  = new LinkedHashMap<String, String>();
        fromKeyName = null;
        toKeyName = null;
        acquiredLock = false;
        renameStatus = true;
        try {
            bucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
            bucket.audit(auditMap /* !! */ );
            volumeName = bucket.realVolume();
            bucketName = bucket.realBucket();
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            volumeOwner = this.getVolumeOwner(omMetadataManager, volumeName);
            for (OzoneManagerProtocolProtos.RenameKeysMap renameKey : renameKeysArgs.getRenameKeysMapList()) {
                fromKeyName = renameKey.getFromKeyName();
                toKeyName = renameKey.getToKeyName();
                unRenameKey = OzoneManagerProtocolProtos.RenameKeysMap.newBuilder();
                if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                    renameStatus = false;
                    unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                    OMKeysRenameRequest.LOG.error("Key name is empty fromKeyName {} toKeyName {}", (Object)fromKeyName, (Object)toKeyName);
                    continue;
                }
                try {
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, fromKeyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY, volumeOwner);
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, toKeyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY, volumeOwner);
                }
                catch (Exception ex) {
                    renameStatus = false;
                    unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                    OMKeysRenameRequest.LOG.error("Acl check failed for fromKeyName {} toKeyName {}", new Object[]{fromKeyName, toKeyName, ex});
                    continue;
                }
                fromKey = omMetadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
                toKey = omMetadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
                toKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)toKey);
                if (toKeyValue != null) {
                    renameStatus = false;
                    unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                    OMKeysRenameRequest.LOG.error("Received a request name of new key {} already exists", (Object)toKeyName);
                }
                if ((fromKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)fromKey)) == null) {
                    renameStatus = false;
                    unRenamedKeys.add(unRenameKey.setFromKeyName(fromKeyName).setToKeyName(toKeyName).build());
                    OMKeysRenameRequest.LOG.error("Received a request to rename a Key does not exist {}", (Object)fromKey);
                    continue;
                }
                fromKeyValue.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                fromKeyValue.setKeyName(toKeyName);
                fromKeyValue.setModificationTime(Time.now());
                keyTable = omMetadataManager.getKeyTable();
                keyTable.addCacheEntry(new CacheKey((Object)fromKey), new CacheValue(Optional.absent(), trxnLogIndex));
                keyTable.addCacheEntry(new CacheKey((Object)toKey), new CacheValue(Optional.of((Object)fromKeyValue), trxnLogIndex));
                renamedKeys.put(fromKeyName, toKeyName);
                fromKeyAndToKeyInfo.put(fromKeyName, fromKeyValue);
            }
            newOmRenameKeys = new OmRenameKeys(volumeName, bucketName, null, fromKeyAndToKeyInfo);
            omClientResponse = new OMKeysRenameResponse(omResponse.setRenameKeysResponse(OzoneManagerProtocolProtos.RenameKeysResponse.newBuilder().setStatus(renameStatus).addAllUnRenamedKeys(unRenamedKeys)).setStatus(renameStatus != false ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_RENAME).setSuccess(renameStatus).build(), newOmRenameKeys);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                this.createErrorOMResponse(omResponse, ex);
                omResponse.setRenameKeysResponse(OzoneManagerProtocolProtos.RenameKeysResponse.newBuilder().setStatus(renameStatus).addAllUnRenamedKeys(unRenamedKeys).build());
                omClientResponse = new OMKeysRenameResponse(omResponse.build());
            }
            catch (Throwable var34_35) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var34_35;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl101
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        auditMap /* !! */  = this.buildAuditMap(auditMap /* !! */ , renamedKeys, unRenamedKeys);
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.RENAME_KEYS, auditMap /* !! */ , exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                OMKeysRenameRequest.LOG.debug("Rename Keys is successfully completed for auditMap:{}.", auditMap /* !! */ );
                break;
            }
            case 2: {
                ozoneManager.getMetrics().incNumKeyRenameFails();
                OMKeysRenameRequest.LOG.error("Rename keys failed for auditMap:{}.", auditMap /* !! */ );
                break;
            }
            default: {
                OMKeysRenameRequest.LOG.error("Unrecognized Result for OMKeysRenameRequest: {}", (Object)renameKeysRequest);
            }
        }
        return omClientResponse;
    }

    private Map<String, String> buildAuditMap(Map<String, String> auditMap, Map<String, String> renamedKeys, List<OzoneManagerProtocolProtos.RenameKeysMap> unRenameKeys) {
        HashMap<String, String> unRenameKeysMap = new HashMap<String, String>();
        for (OzoneManagerProtocolProtos.RenameKeysMap renameKeysMap : unRenameKeys) {
            unRenameKeysMap.put(renameKeysMap.getFromKeyName(), renameKeysMap.getToKeyName());
        }
        auditMap.put("renamedKeysMap", renamedKeys.toString());
        auditMap.put("unRenamedKeysMap", ((Object)unRenameKeysMap).toString());
        return auditMap;
    }
}

