/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMKeyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyRequest.class);

    public OMKeyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketLink(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, Map<String, String> auditMap) throws IOException {
        ResolvedBucket bucket = ozoneManager.resolveBucketLink(keyArgs, (OMClientRequest)this);
        keyArgs = bucket.update(keyArgs);
        bucket.audit(auditMap);
        return keyArgs;
    }

    protected List<OmKeyLocationInfo> allocateBlock(ScmClient scmClient, OzoneBlockTokenSecretManager secretManager, HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor replicationFactor, ExcludeList excludeList, long requestedSize, long scmBlockSize, int preallocateBlocksMax, boolean grpcBlockTokenEnabled, String omID) throws IOException {
        List allocatedBlocks;
        int numBlocks = Math.min((int)((requestedSize - 1L) / scmBlockSize + 1L), preallocateBlocksMax);
        ArrayList<OmKeyLocationInfo> locationInfos = new ArrayList<OmKeyLocationInfo>(numBlocks);
        String remoteUser = this.getRemoteUser().getShortUserName();
        try {
            allocatedBlocks = scmClient.getBlockClient().allocateBlock(scmBlockSize, numBlocks, replicationType, replicationFactor, omID, excludeList);
        }
        catch (SCMException ex) {
            if (ex.getResult().equals((Object)SCMException.ResultCodes.SAFE_MODE_EXCEPTION)) {
                throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
            }
            throw ex;
        }
        for (AllocatedBlock allocatedBlock : allocatedBlocks) {
            OmKeyLocationInfo.Builder builder = new OmKeyLocationInfo.Builder().setBlockID(new BlockID(allocatedBlock.getBlockID())).setLength(scmBlockSize).setOffset(0L).setPipeline(allocatedBlock.getPipeline());
            if (grpcBlockTokenEnabled) {
                builder.setToken(secretManager.generateToken(remoteUser, allocatedBlock.getBlockID().toString(), EnumSet.of(HddsProtos.BlockTokenSecretProto.AccessModeProto.READ, HddsProtos.BlockTokenSecretProto.AccessModeProto.WRITE), scmBlockSize));
            }
            locationInfos.add(builder.build());
        }
        return locationInfos;
    }

    private UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    public void validateBucketAndVolume(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        if (!omMetadataManager.getBucketTable().isExist((Object)bucketKey)) {
            String volumeKey = omMetadataManager.getVolumeKey(volumeName);
            if (!omMetadataManager.getVolumeTable().isExist((Object)volumeKey)) {
                throw new OMException("Volume not found " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            throw new OMException("Bucket not found " + bucketName, OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    protected String getVolumeOwner(OMMetadataManager omMetadataManager, String volumeName) throws IOException {
        String dbVolumeKey = omMetadataManager.getVolumeKey(volumeName);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            throw new OMException("Volume not found " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return volumeArgs.getOwnerName();
    }

    protected static Optional<FileEncryptionInfo> getFileEncryptionInfo(OzoneManager ozoneManager, OmBucketInfo bucketInfo) throws IOException {
        Optional encInfo = Optional.absent();
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = OMKeyRequest.generateEDEK(ozoneManager, ezKeyName);
            encInfo = Optional.of((Object)new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName()));
        }
        return encInfo;
    }

    private static KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final OzoneManager ozoneManager, final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return ozoneManager.getKmsProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    protected OmKeyInfo createKeyInfo(@Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, @Nonnull List<OmKeyLocationInfo> locations, @Nonnull HddsProtos.ReplicationFactor factor, @Nonnull HddsProtos.ReplicationType type, long size, @Nullable FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, long transactionLogIndex, long objectID) {
        return new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, locations))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(size).setReplicationType(type).setReplicationFactor(factor).setFileEncryptionInfo(encInfo).setAcls(this.getAclsForKey(keyArgs, omBucketInfo, prefixManager)).addAllMetadata(KeyValueUtil.getFromProtobuf((List)keyArgs.getMetadataList())).setObjectID(objectID).setUpdateID(transactionLogIndex).build();
    }

    protected List<OzoneAcl> getAclsForKey(OzoneManagerProtocolProtos.KeyArgs keyArgs, OmBucketInfo bucketInfo, PrefixManager prefixManager) {
        OmPrefixInfo prefixInfo;
        List<OmPrefixInfo> prefixList;
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        if (keyArgs.getAclsList() != null) {
            acls.addAll(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()));
        }
        if (prefixManager != null && (prefixList = prefixManager.getLongestPrefixPath("/" + keyArgs.getVolumeName() + "/" + keyArgs.getBucketName() + "/" + keyArgs.getKeyName())).size() > 0 && (prefixInfo = prefixList.get(prefixList.size() - 1)) != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)prefixInfo.getAcls())) {
            return acls;
        }
        if (bucketInfo != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)bucketInfo.getAcls())) {
            return acls;
        }
        return acls;
    }

    protected OmKeyInfo prepareKeyInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, OmKeyInfo dbKeyInfo, long size, @Nonnull List<OmKeyLocationInfo> locations, @Nullable FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, long transactionLogIndex, @Nonnull long objectID, boolean isRatisEnabled) throws IOException {
        if (keyArgs.getIsMultipartKey()) {
            return this.prepareMultipartKeyInfo(omMetadataManager, keyArgs, size, locations, encInfo, prefixManager, omBucketInfo, transactionLogIndex, objectID);
        }
        if (dbKeyInfo != null) {
            dbKeyInfo.addNewVersion(locations, false);
            dbKeyInfo.setDataSize(size + dbKeyInfo.getDataSize());
            dbKeyInfo.setModificationTime(keyArgs.getModificationTime());
            dbKeyInfo.setUpdateID(transactionLogIndex, isRatisEnabled);
            return dbKeyInfo;
        }
        return this.createKeyInfo(keyArgs, locations, keyArgs.getFactor(), keyArgs.getType(), keyArgs.getDataSize(), encInfo, prefixManager, omBucketInfo, transactionLogIndex, objectID);
    }

    private OmKeyInfo prepareMultipartKeyInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs args, long size, @Nonnull List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, @Nonnull long transactionLogIndex, @Nonnull long objectId) throws IOException {
        Preconditions.checkArgument((args.getMultipartNumber() > 0 ? 1 : 0) != 0, (Object)"PartNumber Should be greater than zero");
        String uploadID = args.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID);
        String multipartKey = omMetadataManager.getMultipartKey(args.getVolumeName(), args.getBucketName(), args.getKeyName(), uploadID);
        OmKeyInfo partKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)multipartKey);
        if (partKeyInfo == null) {
            throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        HddsProtos.ReplicationFactor factor = partKeyInfo.getFactor();
        HddsProtos.ReplicationType type = partKeyInfo.getType();
        return this.createKeyInfo(args, locations, factor, type, size, encInfo, prefixManager, omBucketInfo, transactionLogIndex, objectId);
    }

    protected void checkBucketAcls(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType) throws IOException {
        if (ozoneManager.getAclsEnabled()) {
            this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, aclType, volume, bucket, key);
        }
    }

    protected void checkKeyAcls(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType, OzoneObj.ResourceType resourceType) throws IOException {
        if (ozoneManager.getAclsEnabled()) {
            this.checkAcls(ozoneManager, resourceType, OzoneObj.StoreType.OZONE, aclType, volume, bucket, key);
        }
    }

    protected void checkKeyAcls(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType, OzoneObj.ResourceType resourceType, String volumeOwner) throws IOException {
        if (ozoneManager.getAclsEnabled()) {
            this.checkAcls(ozoneManager, resourceType, OzoneObj.StoreType.OZONE, aclType, volume, bucket, key, volumeOwner);
        }
    }

    protected void checkKeyAclsInOpenKeyTable(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType, long clientId) throws IOException {
        String keyNameForAclCheck = key;
        if (ozoneManager.isNativeAuthorizerEnabled()) {
            keyNameForAclCheck = key + "/" + clientId;
        }
        this.checkKeyAcls(ozoneManager, volume, bucket, keyNameForAclCheck, aclType, OzoneObj.ResourceType.KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateRequiredEncryptionInfo(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs, OzoneManager ozoneManager) throws IOException {
        Optional<FileEncryptionInfo> encryptionInfo;
        OmBucketInfo bucketInfo;
        block4: {
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            boolean acquireLock = false;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            bucketInfo = null;
            if (ozoneManager.getKmsProvider() == null) return;
            try {
                acquireLock = omMetadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                if (!acquireLock) break block4;
            }
            catch (Throwable throwable) {
                if (acquireLock) {
                    omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw throwable;
            }
            omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        if (bucketInfo != null && (encryptionInfo = OMKeyRequest.getFileEncryptionInfo(ozoneManager, bucketInfo)).isPresent()) {
            newKeyArgs.setFileEncryptionInfo(OMPBHelper.convert((FileEncryptionInfo)((FileEncryptionInfo)encryptionInfo.get())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getFileEncryptionInfoForMpuKey(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs, OzoneManager ozoneManager) throws IOException {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        boolean acquireLock = false;
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        if (ozoneManager.getKmsProvider() == null) return;
        acquireLock = omMetadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)omMetadataManager.getMultipartKey(volumeName, bucketName, keyArgs.getKeyName(), keyArgs.getMultipartUploadID()));
            if (omKeyInfo != null && omKeyInfo.getFileEncryptionInfo() != null) {
                newKeyArgs.setFileEncryptionInfo(OMPBHelper.convert((FileEncryptionInfo)omKeyInfo.getFileEncryptionInfo()));
            }
            if (!acquireLock) return;
        }
        catch (Throwable throwable) {
            if (!acquireLock) throw throwable;
            omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    protected FileEncryptionInfo getFileEncryptionInfo(OzoneManagerProtocolProtos.KeyArgs keyArgs) {
        FileEncryptionInfo encryptionInfo = null;
        if (keyArgs.hasFileEncryptionInfo()) {
            encryptionInfo = OMPBHelper.convert((OzoneManagerProtocolProtos.FileEncryptionInfoProto)keyArgs.getFileEncryptionInfo());
        }
        return encryptionInfo;
    }

    protected void checkBucketQuotaInBytes(OmBucketInfo omBucketInfo, long allocateSize) throws IOException {
        if (omBucketInfo.getQuotaInBytes() > -1L) {
            long usedBytes = omBucketInfo.getUsedBytes();
            long quotaInBytes = omBucketInfo.getQuotaInBytes();
            if (quotaInBytes - usedBytes < allocateSize) {
                throw new OMException("The DiskSpace quota of bucket:" + omBucketInfo.getBucketName() + "exceeded: quotaInBytes: " + quotaInBytes + " Bytes but diskspace consumed: " + (usedBytes + allocateSize) + " Bytes.", OMException.ResultCodes.QUOTA_EXCEEDED);
            }
        }
    }

    protected void checkBucketQuotaInNamespace(OmBucketInfo omBucketInfo, long allocatedNamespace) throws IOException {
        if (omBucketInfo.getQuotaInNamespace() > -1L) {
            long toUseNamespaceInTotal;
            long usedNamespace = omBucketInfo.getUsedNamespace();
            long quotaInNamespace = omBucketInfo.getQuotaInNamespace();
            if (quotaInNamespace < (toUseNamespaceInTotal = usedNamespace + allocatedNamespace)) {
                throw new OMException("The namespace quota of Bucket:" + omBucketInfo.getBucketName() + " exceeded: quotaInNamespace: " + quotaInNamespace + " but namespace consumed: " + toUseNamespaceInTotal + ".", OMException.ResultCodes.QUOTA_EXCEEDED);
            }
        }
    }

    protected boolean checkDirectoryAlreadyExists(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return omMetadataManager.getKeyTable().isExist((Object)omMetadataManager.getOzoneDirKey(volumeName, bucketName, keyName));
    }

    protected static long sumBlockLengths(OmKeyInfo omKeyInfo) {
        long bytesUsed = 0L;
        int keyFactor = omKeyInfo.getFactor().getNumber();
        OmKeyLocationInfoGroup keyLocationGroup = omKeyInfo.getLatestVersionLocations();
        for (OmKeyLocationInfo locationInfo : keyLocationGroup.getLocationList()) {
            bytesUsed += locationInfo.getLength() * (long)keyFactor;
        }
        return bytesUsed;
    }

    protected OmBucketInfo getBucketInfo(OMMetadataManager omMetadataManager, String volume, String bucket) {
        return (OmBucketInfo)omMetadataManager.getBucketTable().getCacheValue(new CacheKey((Object)omMetadataManager.getBucketKey(volume, bucket))).getCacheValue();
    }
}

