/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileCreateRequest.class);

    public OMFileCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        HddsProtos.ReplicationType type;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = this.getOmRequest().getCreateFileRequest();
        Preconditions.checkNotNull((Object)createFileRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
        boolean checkKeyNameEnabled = ozoneManager.getConfiguration().getBoolean("ozone.om.keyname.character.check.enabled", false);
        if (checkKeyNameEnabled) {
            OmUtils.validateKeyName((String)StringUtils.removeEnd((String)keyArgs.getKeyName(), (String)"._COPYING_"));
        }
        if (keyArgs.getKeyName().length() == 0) {
            return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).build();
        }
        long scmBlockSize = ozoneManager.getScmBlockSize();
        long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
        boolean useRatis = ozoneManager.shouldUseRatis();
        HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
        if (factor == null) {
            HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
        }
        if ((type = keyArgs.getType()) == null) {
            type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
        }
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
        newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(info -> info.getProtobuf(this.getOmRequest().getVersion())).collect(Collectors.toList()));
        this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        OzoneManagerProtocolProtos.CreateFileRequest.Builder newCreateFileRequest = createFileRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateFileRequest(newCreateFileRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        createFileRequest = this.getOmRequest().getCreateFileRequest();
        keyArgs = createFileRequest.getKeyArgs();
        auditMap = this.buildKeyArgsAuditMap(keyArgs);
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        numMissingParents = 0;
        isRecursive = createFileRequest.getIsRecursive();
        if (OMFileCreateRequest.LOG.isDebugEnabled()) {
            OMFileCreateRequest.LOG.debug("File create for : " + volumeName + "/" + bucketName + "/" + keyName + ":" + isRecursive);
        }
        isOverWrite = createFileRequest.getIsOverwrite();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumCreateFile();
        omMetadataManager = ozoneManager.getMetadataManager();
        acquiredLock = false;
        omKeyInfo = null;
        omBucketInfo = null;
        locations = new ArrayList<OmKeyLocationInfo>();
        omClientResponse = null;
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        exception = null;
        result = null;
        try {
            keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            if (keyName.length() == 0) {
                throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
            }
            ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().getIfExist((Object)ozoneKey);
            if (dbKeyInfo != null) {
                ozoneManager.getKeyManager().refresh(dbKeyInfo);
            }
            pathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
            omDirectoryResult = pathInfo.getDirectoryResult();
            inheritAcls = pathInfo.getAcls();
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
                if (!isOverWrite) {
                    throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                }
            } else {
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                    throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                }
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                    throw new OMException("Can not create file: " + keyName + " as there is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
                }
            }
            if (!isRecursive) {
                this.checkAllParentsExist(ozoneManager, keyArgs, pathInfo);
            }
            bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, trxnLogIndex, ozoneManager.getObjectIdFromTxId(trxnLogIndex), ozoneManager.isRatisEnabled());
            openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
            clientID = createFileRequest.getClientID();
            dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            missingParentInfos = OMDirectoryCreateRequest.getAllParentInfo(ozoneManager, keyArgs, pathInfo.getMissingParents(), inheritAcls, trxnLogIndex);
            newLocationList = keyArgs.getKeyLocationsList().stream().map((Function<OzoneManagerProtocolProtos.KeyLocation, OmKeyLocationInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFromProtobuf(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$KeyLocation ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$KeyLocation;)Lorg/apache/hadoop/ozone/om/helpers/OmKeyLocationInfo;)()).collect(Collectors.toList());
            omKeyInfo.appendNewBlocks(newLocationList, false);
            omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
            preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)omKeyInfo.getFactor().getNumber();
            this.checkBucketQuotaInBytes(omBucketInfo, preAllocatedSpace);
            this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)dbOpenKeyName), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
            OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, (Optional<OmKeyInfo>)Optional.absent(), (Optional<List<OmKeyInfo>>)Optional.of(missingParentInfos), trxnLogIndex);
            omBucketInfo.incrUsedBytes(preAllocatedSpace);
            omBucketInfo.incrUsedNamespace(1L);
            numMissingParents = missingParentInfos.size();
            omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omKeyInfo.getProtobuf(this.getOmRequest().getVersion())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
            omClientResponse = new OMFileCreateResponse(omResponse.build(), omKeyInfo, missingParentInfos, clientID, omBucketInfo.copyObject());
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = OMClientRequest.Result.FAILURE;
                exception = ex;
                omMetrics.incNumCreateFileFails();
                omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                omClientResponse = new OMFileCreateResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var39_36) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var39_36;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl91
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_FILE, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                omMetrics.incNumKeys(numMissingParents);
                OMFileCreateRequest.LOG.debug("File created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case 2: {
                OMFileCreateRequest.LOG.error("File create failed. Volume:{}, Bucket:{}, Key{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                OMFileCreateRequest.LOG.error("Unrecognized Result for OMFileCreateRequest: {}", (Object)createFileRequest);
            }
        }
        return omClientResponse;
    }

    private void checkAllParentsExist(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMFileRequest.OMPathInfo pathInfo) throws IOException {
        String keyName = keyArgs.getKeyName();
        if (!pathInfo.directParentExists()) {
            throw new OMException("Cannot create file : " + keyName + " as one of parent directory is not created", OMException.ResultCodes.DIRECTORY_NOT_FOUND);
        }
    }
}

