/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.conf.OMClientConfig;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashPolicyOzone
extends TrashPolicyDefault {
    private static final Logger LOG = LoggerFactory.getLogger(TrashPolicyOzone.class);
    private static final Path CURRENT = new Path("Current");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmmss");
    private static final DateFormat OLD_CHECKPOINT = new SimpleDateFormat("yyMMddHHmm");
    private static final int MSECS_PER_MINUTE = 60000;
    private long emptierInterval;
    private Configuration configuration;
    private OzoneManager om;

    public TrashPolicyOzone() {
    }

    public void initialize(Configuration conf, FileSystem fs) {
        this.fs = fs;
        this.configuration = conf;
        float hadoopTrashInterval = conf.getFloat("fs.trash.interval", 0.0f);
        this.deletionInterval = (long)(conf.getFloat("ozone.fs.trash.interval", hadoopTrashInterval) * 60000.0f);
        float hadoopCheckpointInterval = conf.getFloat("fs.trash.checkpoint.interval", 0.0f);
        this.emptierInterval = (long)(conf.getFloat("ozone.fs.trash.checkpoint.interval", hadoopCheckpointInterval) * 60000.0f);
        if (this.deletionInterval < 0L) {
            LOG.warn("Invalid value {} for deletion interval, deletion interaval can not be negative.Changing to default value 0", (Object)this.deletionInterval);
            this.deletionInterval = 0L;
        }
    }

    TrashPolicyOzone(FileSystem fs, Configuration conf, OzoneManager om) {
        this.initialize(conf, fs);
        this.om = om;
    }

    public Runnable getEmptier() throws IOException {
        return new Emptier((OzoneConfiguration)this.configuration, this.emptierInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheckpoint(Path trashRoot, Date date) throws IOException {
        Path checkpointBase;
        if (!this.fs.exists(new Path(trashRoot, CURRENT))) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpointBase = new Path(trashRoot, CHECKPOINT.format(date));
        }
        Path checkpoint = checkpointBase;
        Path current = new Path(trashRoot, CURRENT);
        int attempt = 0;
        while (true) {
            try {
                this.fs.rename(current, checkpoint);
                LOG.debug("Created trash checkpoint: " + checkpoint.toUri().getPath());
            }
            catch (FileAlreadyExistsException e) {
                if (++attempt > 1000) {
                    this.om.getMetrics().incNumTrashFails();
                    throw new IOException("Failed to checkpoint trash: " + checkpoint);
                }
                checkpoint = checkpointBase.suffix("-" + attempt);
                continue;
            }
            break;
        }
    }

    private void deleteCheckpoint(Path trashRoot, boolean deleteImmediately) throws IOException {
        LOG.debug("TrashPolicyOzone#deleteCheckpoint for trashRoot: " + trashRoot);
        FileStatus[] dirs = null;
        try {
            dirs = this.fs.listStatus(trashRoot);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        long now = Time.now();
        for (int i = 0; i < dirs.length; ++i) {
            long time;
            Path path = dirs[i].getPath();
            String dir = path.toUri().getPath();
            String name = path.getName();
            if (name.equals(CURRENT.getName())) continue;
            try {
                time = this.getTimeFromCheckpoint(name);
            }
            catch (ParseException e) {
                this.om.getMetrics().incNumTrashFails();
                LOG.warn("Unexpected item in trash: " + dir + ". Ignoring.");
                continue;
            }
            if (now - this.deletionInterval <= time && !deleteImmediately) continue;
            if (this.fs.delete(path, true)) {
                LOG.debug("Deleted trash checkpoint:{} ", (Object)dir);
                continue;
            }
            this.om.getMetrics().incNumTrashFails();
            LOG.warn("Couldn't delete checkpoint: " + dir + " Ignoring.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeFromCheckpoint(String name) throws ParseException {
        long time;
        try {
            DateFormat dateFormat = CHECKPOINT;
            synchronized (dateFormat) {
                time = CHECKPOINT.parse(name).getTime();
            }
        }
        catch (ParseException pe) {
            DateFormat dateFormat = OLD_CHECKPOINT;
            synchronized (dateFormat) {
                time = OLD_CHECKPOINT.parse(name).getTime();
            }
        }
        return time;
    }

    protected class Emptier
    implements Runnable {
        private Configuration conf;
        private long emptierInterval;
        private ThreadPoolExecutor executor;

        Emptier(OzoneConfiguration conf, long emptierInterval) throws IOException {
            this.conf = conf;
            this.emptierInterval = emptierInterval;
            if (emptierInterval > TrashPolicyOzone.this.deletionInterval || emptierInterval <= 0L) {
                LOG.info("The configured checkpoint interval is " + emptierInterval / 60000L + " minutes. Using an interval of " + TrashPolicyOzone.this.deletionInterval / 60000L + " minutes that is used for deletion instead");
                this.emptierInterval = TrashPolicyOzone.this.deletionInterval;
            }
            int trashEmptierCorePoolSize = ((OMClientConfig)conf.getObject(OMClientConfig.class)).getTrashEmptierPoolSize();
            LOG.info("Ozone Manager trash configuration: Deletion interval = " + TrashPolicyOzone.this.deletionInterval / 60000L + " minutes, Emptier interval = " + this.emptierInterval / 60000L + " minutes.");
            this.executor = new ThreadPoolExecutor(trashEmptierCorePoolSize, trashEmptierCorePoolSize, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.CallerRunsPolicy());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.emptierInterval == 0L) {
                return;
            }
            block15: while (true) {
                long now = Time.now();
                long end = this.ceiling(now, this.emptierInterval);
                try {
                    Thread.sleep(end - now);
                    if (!TrashPolicyOzone.this.om.isLeaderReady()) {
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    TrashPolicyOzone.this.om.getMetrics().incNumTrashActiveCycles();
                    now = Time.now();
                    if (now < end) continue;
                    Collection trashRoots = TrashPolicyOzone.this.fs.getTrashRoots(true);
                    LOG.debug("Trash root Size: " + trashRoots.size());
                    Iterator iterator = trashRoots.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block15;
                        FileStatus trashRoot = (FileStatus)iterator.next();
                        LOG.debug("Trashroot:" + trashRoot.getPath().toString());
                        if (!trashRoot.isDirectory()) continue;
                        TrashPolicyOzone trash = new TrashPolicyOzone(TrashPolicyOzone.this.fs, this.conf, TrashPolicyOzone.this.om);
                        Runnable task = () -> {
                            try {
                                TrashPolicyOzone.this.om.getMetrics().incNumTrashRootsProcessed();
                                trash.deleteCheckpoint(trashRoot.getPath(), false);
                                trash.createCheckpoint(trashRoot.getPath(), new Date(Time.now()));
                            }
                            catch (Exception e) {
                                TrashPolicyOzone.this.om.getMetrics().incNumTrashFails();
                                LOG.error("Unable to checkpoint:" + trashRoot.getPath(), (Throwable)e);
                            }
                        };
                        TrashPolicyOzone.this.om.getMetrics().incNumTrashRootsEnqueued();
                        this.executor.submit(task);
                    }
                }
                catch (Exception e) {
                    TrashPolicyOzone.this.om.getMetrics().incNumTrashFails();
                    LOG.warn("RuntimeException during Trash.Emptier.run(): ", (Throwable)e);
                    continue;
                }
                break;
            }
            try {
                TrashPolicyOzone.this.fs.close();
            }
            catch (IOException e) {
                LOG.warn("Trash cannot close FileSystem: ", (Throwable)e);
            }
            finally {
                this.executor.shutdown();
                try {
                    this.executor.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.error("Error attempting to shutdown", (Throwable)e);
                }
            }
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }
    }
}

