/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.Node;

public class NodeImpl
implements Node {
    private String name;
    private String location;
    private String path;
    private int level;
    private InnerNode parent;
    private final int cost;

    public NodeImpl(String name, String location, int cost) {
        if (name != null && name.contains("/")) {
            throw new IllegalArgumentException("Network location name:" + name + " should not contain " + "/");
        }
        this.name = name == null ? "" : name;
        this.location = NetUtils.normalize(location);
        this.path = this.getPath();
        this.cost = cost;
    }

    public NodeImpl(String name, String location, InnerNode parent, int level, int cost) {
        this(name, location, cost);
        this.parent = parent;
        this.level = level;
    }

    @Override
    public String getNetworkName() {
        return this.name;
    }

    @Override
    public void setNetworkName(String networkName) {
        this.name = networkName;
        this.path = this.getPath();
    }

    @Override
    public String getNetworkLocation() {
        return this.location;
    }

    @Override
    public void setNetworkLocation(String networkLocation) {
        this.location = networkLocation;
        this.path = this.getPath();
    }

    @Override
    public String getNetworkFullPath() {
        return this.path;
    }

    @Override
    public InnerNode getParent() {
        return this.parent;
    }

    @Override
    public Node getAncestor(int generation) {
        Node current;
        Preconditions.checkArgument((generation >= 0 ? 1 : 0) != 0);
        for (current = this; generation > 0 && current != null; current = current.getParent(), --generation) {
        }
        return current;
    }

    @Override
    public void setParent(InnerNode parent) {
        this.parent = parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public int getNumOfLeaves() {
        return 1;
    }

    @Override
    public boolean isAncestor(Node node) {
        return this.getNetworkFullPath().equals("/") || node.getNetworkLocation().startsWith(this.getNetworkFullPath()) || node.getNetworkFullPath().equalsIgnoreCase(this.getNetworkFullPath());
    }

    public boolean equals(Object to) {
        if (to == null) {
            return false;
        }
        if (this == to) {
            return true;
        }
        return this.toString().equals(to.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getNetworkFullPath();
    }

    private String getPath() {
        return this.location.equals("/") ? this.location + this.name : this.location + "/" + this.name;
    }
}

