/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ContainerID
implements Comparable<ContainerID> {
    private final long id;

    public ContainerID(long id) {
        this.id = id;
    }

    public static ContainerID valueof(long containerID) {
        Preconditions.checkState((containerID > 0L ? 1 : 0) != 0, (Object)("Container ID should be a positive long. " + containerID));
        return new ContainerID(containerID);
    }

    public long getId() {
        return this.id;
    }

    public byte[] getBytes() {
        return Longs.toByteArray((long)this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerID that = (ContainerID)o;
        return new EqualsBuilder().append(this.getId(), that.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 71).append(this.getId()).toHashCode();
    }

    @Override
    public int compareTo(ContainerID that) {
        Preconditions.checkNotNull((Object)that);
        return new CompareToBuilder().append(this.getId(), that.getId()).build();
    }

    public String toString() {
        return "#" + this.id;
    }
}

