/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.apache.hadoop.hdds.ratis.retrypolicy.RetryPolicyCreator;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RatisHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RatisHelper.class);
    public static final String HDDS_DATANODE_RATIS_PREFIX_KEY = "hdds.ratis";
    private static final RaftGroupId DUMMY_GROUP_ID = RaftGroupId.valueOf((ByteString)ByteString.copyFromUtf8((String)"AOzoneRatisGroup"));
    private static final RaftGroup EMPTY_GROUP = RaftGroup.valueOf((RaftGroupId)DUMMY_GROUP_ID, Collections.emptyList());

    private RatisHelper() {
    }

    private static String toRaftPeerIdString(DatanodeDetails id) {
        return id.getUuidString();
    }

    public static UUID toDatanodeId(String peerIdString) {
        return UUID.fromString(peerIdString);
    }

    public static UUID toDatanodeId(RaftPeerId peerId) {
        return RatisHelper.toDatanodeId(peerId.toString());
    }

    public static UUID toDatanodeId(RaftProtos.RaftPeerProto peerId) {
        return RatisHelper.toDatanodeId(RaftPeerId.valueOf((ByteString)peerId.getId()));
    }

    private static String toRaftPeerAddress(DatanodeDetails id, DatanodeDetails.Port.Name port) {
        return id.getIpAddress() + ":" + id.getPort(port).getValue();
    }

    public static RaftPeerId toRaftPeerId(DatanodeDetails id) {
        return RaftPeerId.valueOf((String)RatisHelper.toRaftPeerIdString(id));
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id) {
        return RatisHelper.raftPeerBuilderFor(id).build();
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id, int priority) {
        return RatisHelper.raftPeerBuilderFor(id).setPriority(priority).build();
    }

    private static RaftPeer.Builder raftPeerBuilderFor(DatanodeDetails dn) {
        return RaftPeer.newBuilder().setId(RatisHelper.toRaftPeerId(dn)).setAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS_SERVER)).setAdminAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS_ADMIN)).setClientAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS));
    }

    private static List<RaftPeer> toRaftPeers(Pipeline pipeline) {
        return RatisHelper.toRaftPeers(pipeline.getNodes());
    }

    private static <E extends DatanodeDetails> List<RaftPeer> toRaftPeers(List<E> datanodes) {
        return datanodes.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
    }

    private static RaftGroup emptyRaftGroup() {
        return EMPTY_GROUP;
    }

    private static RaftGroup newRaftGroup(Collection<RaftPeer> peers) {
        return peers.isEmpty() ? RatisHelper.emptyRaftGroup() : RaftGroup.valueOf((RaftGroupId)DUMMY_GROUP_ID, peers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, List<DatanodeDetails> peers, List<Integer> priorityList) {
        assert (peers.size() == priorityList.size());
        ArrayList<RaftPeer> newPeers = new ArrayList<RaftPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            RaftPeer peer = RatisHelper.toRaftPeer(peers.get(i), priorityList.get(i));
            newPeers.add(peer);
        }
        return peers.isEmpty() ? RaftGroup.valueOf((RaftGroupId)groupId, Collections.emptyList()) : RaftGroup.valueOf((RaftGroupId)groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, Collection<DatanodeDetails> peers) {
        List newPeers = peers.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
        return peers.isEmpty() ? RaftGroup.valueOf((RaftGroupId)groupId, Collections.emptyList()) : RaftGroup.valueOf((RaftGroupId)groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(Pipeline pipeline) {
        return RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((UUID)pipeline.getId().getId()), RatisHelper.toRaftPeers(pipeline));
    }

    public static RaftClient newRaftClient(RpcType rpcType, Pipeline pipeline, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource ozoneConfiguration) throws IOException {
        return RatisHelper.newRaftClient(rpcType, RatisHelper.toRaftPeerId(pipeline.getLeaderNode()), RatisHelper.newRaftGroup(RaftGroupId.valueOf((UUID)pipeline.getId().getId()), pipeline.getNodes()), retryPolicy, tlsConfig, ozoneConfiguration);
    }

    private static RpcType getRpcType(ConfigurationSource conf) {
        return SupportedRpcType.valueOfIgnoreCase((String)conf.get("dfs.container.ratis.rpc.type", "GRPC"));
    }

    public static RaftClient newRaftClient(RaftPeer leader, ConfigurationSource conf, GrpcTlsConfig tlsConfig) {
        return RatisHelper.newRaftClient(RatisHelper.getRpcType(conf), leader, RatisHelper.createRetryPolicy(conf), tlsConfig, conf);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource configuration) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(Collections.singletonList(leader)), retryPolicy, tlsConfig, configuration);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, ConfigurationSource ozoneConfiguration) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(Collections.singletonList(leader)), retryPolicy, null, ozoneConfiguration);
    }

    private static RaftClient newRaftClient(RpcType rpcType, RaftPeerId leader, RaftGroup group, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource ozoneConfiguration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("newRaftClient: {}, leader={}, group={}", new Object[]{rpcType, leader, group});
        }
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpcType);
        RatisHelper.createRaftClientProperties(ozoneConfiguration, properties);
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leader).setProperties(properties).setRetryPolicy(retryPolicy);
        if (tlsConfig != null && rpcType == SupportedRpcType.GRPC) {
            Parameters parameters = new Parameters();
            GrpcConfigKeys.Client.setTlsConf((Parameters)parameters, (GrpcTlsConfig)tlsConfig);
            builder.setParameters(parameters);
        }
        return builder.build();
    }

    public static void createRaftClientProperties(ConfigurationSource ozoneConf, RaftProperties raftProperties) {
        Map<String, String> ratisClientConf = RatisHelper.getDatanodeRatisPrefixProps(ozoneConf);
        ratisClientConf.forEach((key, val) -> {
            if (RatisHelper.isClientConfig(key) || RatisHelper.isGrpcClientConfig(key)) {
                raftProperties.set(key, val);
            }
        });
    }

    private static boolean isClientConfig(String key) {
        return key.startsWith("raft.client");
    }

    private static boolean isGrpcClientConfig(String key) {
        return key.startsWith("raft.grpc") && !key.startsWith("raft.grpc.tls") && !key.startsWith("raft.grpc.admin") && !key.startsWith("raft.grpc.server");
    }

    public static void createRaftServerProperties(ConfigurationSource ozoneConf, RaftProperties raftProperties) {
        Map<String, String> ratisServerConf = RatisHelper.getDatanodeRatisPrefixProps(ozoneConf);
        ratisServerConf.forEach((key, val) -> {
            if (!RatisHelper.isClientConfig(key)) {
                raftProperties.set(key, val);
            }
        });
    }

    private static Map<String, String> getDatanodeRatisPrefixProps(ConfigurationSource configuration) {
        return configuration.getPropsWithPrefix(StringUtils.appendIfNotPresent(HDDS_DATANODE_RATIS_PREFIX_KEY, '.'));
    }

    public static GrpcTlsConfig createTlsClientConfig(SecurityConfig conf, X509Certificate caCert) {
        GrpcTlsConfig tlsConfig = null;
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            tlsConfig = new GrpcTlsConfig(null, null, caCert, false);
        }
        return tlsConfig;
    }

    public static RetryPolicy createRetryPolicy(ConfigurationSource conf) {
        try {
            RatisClientConfig scmClientConfig = (RatisClientConfig)conf.getObject(RatisClientConfig.class);
            Class<RetryPolicyCreator> policyClass = RatisHelper.getClass(scmClientConfig.getRetryPolicy(), RetryPolicyCreator.class);
            return policyClass.newInstance().create(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Long getMinReplicatedIndex(Collection<RaftProtos.CommitInfoProto> commitInfos) {
        return commitInfos.stream().map(RaftProtos.CommitInfoProto::getCommitIndex).min(Long::compareTo).orElse(null);
    }

    private static <U> Class<? extends U> getClass(String name, Class<U> xface) {
        try {
            Class<?> theClass = Class.forName(name);
            if (!xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            return theClass.asSubclass(xface);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

